# coding: utf-8

from sandbox import sdk2
from sandbox.projects.market.solomon_pusher.helpers import common
from sandbox.sandboxsdk import environments
from sandbox.projects.common import task_env
import sandbox.common.types.task as ctt


class BaseTask(sdk2.Task):
    class Requirements(task_env.TinyRequirements):
        # ограничиваем задачи по cpu и памяти, что уменьшить потребляемую квоту
        ram = 2 * 1024  # 2GiB or less
        disk_space = 2 * 1024

        environments = (
            environments.PipEnvironment('psycopg2-binary'),
            environments.PipEnvironment('pymssql==2.1.4'),
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet', version='0.3.32-0'),
            environments.PipEnvironment(
                'yandex_tracker_client', version='1.3', custom_parameters=['--upgrade-strategy only-if-needed']
            ),
            environments.PipEnvironment(
                'startrek_client', version='2.3.0', custom_parameters=['--upgrade-strategy only-if-needed']
            )
        )

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 900

        # custom parameters
        path_to_sql = sdk2.parameters.ArcadiaUrl('Path to sql', required=True)
        additional_args = sdk2.parameters.List('Additional sql args',
                                               description='''Will go after start_date and end_date in case
                                                'Need to use date range' checkbox is enabled''')
        use_date_range = sdk2.parameters.Bool('Need to use date range', required=True, default=False)
        is_testing = sdk2.parameters.Bool('Are you trying to test?', required=True, default=False)
        semaphore_name = sdk2.parameters.String('Semaphore name', required=True, default=common.DEFAULT_SEMAPHORE_NAME)

    def on_enqueue(self):
        # ограничиваем одновременное выполнение задач
        self.Requirements.semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name=self.Parameters.semaphore_name, weight=1)
            ],
        )

    def on_prepare(self):
        sdk2.svn.Arcadia.checkout(common.ARC_PATH_TO_PUSHER, common.TMP_DIR, depth='infinity')
