# coding=utf-8
import logging
import os

from sandbox.projects.market.sre.BuildMarketDatasources import BuildMarketDatasources


from sandbox import sdk2


class MarketDatasourcesDev(sdk2.Resource):
    """Contains Market Datasources
    https://github.yandex-team.ru/cs-admin/datasources-ng-dev
    """
    releasable = True
    backup_task = True


class BuildMarketDevDatasources(BuildMarketDatasources):
    """A task that packs Market Dev Datasources into tarball"""

    def _write_confd_config(self):
        confd_toml_content = """
                          backend = "{}"
                          basic_auth = {}
                          nodes = ["{}"]
                          client_cakeys = "{}"
                          """.format('etcdv3',
                                     'true',
                                     'etcd.tst.vs.market.yandex.net:3379',
                                     '/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt')

        logging.info('Writing confd config: {}'.format(confd_toml_content))
        with open('confd/confd.toml', 'w+') as f:
            f.write(confd_toml_content)

    def on_execute(self):
        self._arc_clone_confd_templates()
        self.confd_directory = os.path.join(os.getcwd(), 'confd')
        self._write_confd_config()

        self._create_datasources_resource(
            resource_type=MarketDatasourcesDev,
            environment_name='development',
        )

