# -*- coding: utf-8 -*-

from urllib import urlretrieve

from sandbox.projects import resource_types
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task

FILENAME = 'market-wheels-size.xml.gz'


class WheelsSizeUrl(parameters.SandboxStringParameter):
    name = 'wheel_size'
    description = '%s url' % FILENAME
    default_value = 'http://s3.mds.yandex.net/misc/verba/market-wheels-size.xml.gz'


class BuildMarketGuruAssistantAutoWheels(task.SandboxTask):
    type = 'BUILD_MARKET_GURU_ASSISTANT_AUTO_WHEELS'

    input_parameters = [WheelsSizeUrl]

    def on_execute(self):
        filename = FILENAME
        url = self.ctx[WheelsSizeUrl.name]
        urlretrieve(url, filename)

        result = self.create_resource(self.descr, filename, resource_types.MARKET_GURU_ASSISTANT_AUTO_WHEELS)
        self.mark_resource_ready(result.id)


__Task__ = BuildMarketGuruAssistantAutoWheels
