# coding=utf-8
import logging

import requests
from sandbox.projects.common.yasm import push_api
from sandbox import sdk2

_INSTANCE_TYPE_TAG = "reservedhosts"
_PROJECT = "marketsre"
_TAG_NAME_FORMAT = "reserved_hosts_{}_tttt"
_GENCFG_URL_FORMAT = "https://api.gencfg.yandex-team.ru/trunk/groups/{}"
_TTL_FOR_SIGNAL = 7200


def get_hosts(group_name):
    req = requests.get(_GENCFG_URL_FORMAT.format(group_name))
    req.raise_for_status()
    return req.json().get("hosts")


class CalculateReservedHosts(sdk2.Task):
    """A task that get hostlist for group and push it to yasm"""

    class Parameters(sdk2.Task.Parameters):
        groups = sdk2.parameters.List(
            "Группы для которых считать",
            sdk2.parameters.String,
            required=True
        )

    def on_execute(self):
        for group in self.Parameters.groups:
            logging.info("Get hosts for group {}".format(group))
            hostlist = get_hosts(str(group))
            logging.info("Hostlist: {}".format(hostlist))
            push_api.push_signal(
                name=_TAG_NAME_FORMAT.format(str(group).lower()),
                prj=_PROJECT,
                value=len(hostlist),
                itype=_INSTANCE_TYPE_TAG,
                ttl=_TTL_FOR_SIGNAL
            )
            logging.info("Metric pushed: {} - {}".format(_TAG_NAME_FORMAT.format(str(group).lower()), len(hostlist)))
