# coding=utf-8

import logging
import os.path
import re

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia, SvnError


class MarketAlertsConfigsCommit(sdk2.Task):
    """Коммит конфигов для market-alerts-configurator."""

    class Parameters(sdk2.Task.Parameters):
        arcadia_user = "zomb-sandbox-rw"
        arcadia_path = sdk2.parameters.String("Путь в Аркадии",
                                              default="market/sre/conf/market-alerts-configs/configs", required=True)
        files_to_commit = sdk2.parameters.Dict("Словарь <имя_файла, содержимое> для коммита", required=True)
        commit_message = sdk2.parameters.String("Сообщение коммита", required=True)
        force = sdk2.parameters.Bool("Насильно переписывать файлы", default=False)
        with sdk2.parameters.Output:
            arcadia_commit_url = sdk2.parameters.String("Commit URL", default="", required=True)

    def on_execute(self):
        # Checkout Arcadia
        arcadia_url = os.path.join(
            Arcadia.ARCADIA_TRUNK_URL,
            str(self.Parameters.arcadia_path))
        arcadia_dir = Arcadia.checkout(arcadia_url, str(self.path("arcadia")))
        logging.info("Arcadia is checkouted to {}".format(arcadia_dir))

        # Write file
        need_to_commit = False
        for name in self.Parameters.files_to_commit:
            file_path = os.path.join(arcadia_dir, name)
            dir_path = os.path.join(arcadia_dir, os.path.dirname(name))
            file_arcadia_path = os.path.join(arcadia_url, name)
            if os.path.isfile(file_path) and not self.Parameters.force:
                logging.info("File {} exists".format(file_arcadia_path))
                continue
            if not os.path.exists(dir_path):
                os.makedirs(dir_path)
                logging.info("Make directory {} ".format(dir_path))
            body = self.Parameters.files_to_commit[name].replace("\\n", "\n") + u"\n"
            logging.info("Writing file {} with body:\n{}".format(file_arcadia_path, body))
            with open(file_path, "w") as fd:
                fd.write(body)
            Arcadia.add(file_path, True)
            need_to_commit = True

        # Commit file
        if need_to_commit:
            try:
                result = Arcadia.commit(arcadia_dir, self.Parameters.commit_message, self.Parameters.arcadia_user)
                logging.info("Commit result: {}".format(result))
                revision = re.findall(r'Committed revision (\d+)\.', result)
                if revision:
                    self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/arc/commit/{}".format(revision[0])
            except SvnError as e:
                logging.error(e.message)
                # For Arcadia reviews
                review = re.findall(r'https://a\.yandex-team\.ru/review/(\d+)', e.message)
                if review:
                    self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/review/{}".format(review[0])
        else:
            self.Parameters.arcadia_commit_url = "Nothing to commit"

        logging.info("Commit/Review URL: {}\nAll done".format(self.Parameters.arcadia_commit_url))
