# coding=utf-8

import logging
import os.path
import re

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia, SvnError


class MarketArcadiaFileCommit(sdk2.Task):
    """Коммит файла в Аркадию."""

    class Parameters(sdk2.Task.Parameters):
        file_path = sdk2.parameters.String("Аркадийный путь к файлу", required=True)
        file_body = sdk2.parameters.String("Содержимое файла", multiline=True, required=True)
        startrek_ticket = sdk2.parameters.String("Ключ тикета в Стартреке", required=True)
        commit_message = sdk2.parameters.String("Сообщение коммита", default="Commit new file", required=True)
        arcadia_user = sdk2.parameters.String("Автор коммита", default="zomb-sandbox-rw", required=True)
        with sdk2.parameters.Output:
            arcadia_commit_url = sdk2.parameters.String("Commit URL", default="", required=True)

    def on_execute(self):
        # Checkout Arcadia
        arcadia_url = os.path.join(
            Arcadia.ARCADIA_TRUNK_URL,
            os.path.dirname(self.Parameters.file_path))
        arcadia_dir = Arcadia.checkout(arcadia_url, str(self.path("arcadia")))
        logging.info("Arcadia is checkouted to {}".format(arcadia_dir))

        # Write file
        file_name = os.path.join(arcadia_dir, os.path.basename(self.Parameters.file_path))
        if os.path.isfile(file_name):
            logging.info("File {} exists".format(file_name))
            return
        with open(file_name, "w") as fd:
            fd.write(self.Parameters.file_body + "\n")
        logging.info("Write content to file {}".format(file_name))

        # Commit file
        Arcadia.add(file_name)
        try:
            commit_message = " ".join((self.Parameters.startrek_ticket, self.Parameters.commit_message))
            result = Arcadia.commit(arcadia_dir, commit_message, self.Parameters.arcadia_user)
            logging.info("Commit result: {}".format(result))
            revision = re.findall(r'Committed revision (\d+)\.', result)
            if revision:
                self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/arc/commit/{}".format(revision[0])
        except SvnError as e:
            logging.error(e.message)
            # For Arcadia reviews
            review = re.findall(r'https://a\.yandex-team\.ru/review/(\d+)', e.message)
            if review:
                self.Parameters.arcadia_commit_url = "https://a.yandex-team.ru/review/{}".format(review[0])

        logging.info("Commit/Review URL: {}\nAll done".format(self.Parameters.arcadia_commit_url))
