import urllib

import requests


def create_conductor_ticket(task, binary_packages, version, branch='testing'):
    CONDUCTOR_URL = "http://c.yandex-team.ru"
    if not binary_packages:
        raise ValueError("Empty package list")
    comment = "created from sandbox task https://sandbox.yandex-team.ru/task/{0}".format(task.id)
    conductor_auth = task.get_vault_data('MARKETSRE', 'csadmin-conductor-auth')
    query_args = [("ticket[branch]", branch), ("ticket[comment]", comment)]
    for idx, package in enumerate(binary_packages):
        query_args.append(("package[{0}]".format(idx), package))
        query_args.append(("version[{0}]".format(idx), version))
    query_url = "{0}/auth_update/ticket_add?{1}".format(CONDUCTOR_URL, urllib.urlencode(query_args, True))
    headers = {"Authorization": "OAuth {0}".format(conductor_auth)}
    requests.get(query_url, headers=headers).raise_for_status()
