from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


def get_newest_resource_id(resource_type, attrs=None):
    res = channel.sandbox.list_resources(
        resource_type=resource_type,
        status='READY',
        hidden=False,
        limit=1,
        all_attrs=attrs
    )
    if res:
        return res[0].id
    return None


def get_newest_resource(task, resource_type, name, attrs=None):
    res_id = get_newest_resource_id(resource_type, attrs)
    if not res_id:
        raise SandboxTaskFailureError("Can't find " + name)
    return task.sync_resource(res_id)
