# -*- coding: utf-8 -*-
from os import path

from sandbox import sdk2

from sandbox.projects.market.sre.MarketDeplateRun import MarketDeplateRun


class Status(object):
    CREATED = "CREATED"
    ERROR = "ERROR"
    NOOP = "NOOP"


class MarketDeplateRunCreate(MarketDeplateRun):
    """
        Create Project with Deplate
    """

    class Parameters(MarketDeplateRun.Parameters):
        deplate_command = None

        with sdk2.parameters.Group("Deplate Create Project", collapse=False) as deplate_generate_block:
            service_name = sdk2.parameters.String("Service name", required=True)
            project_name = sdk2.parameters.String("Project name", required=True)
            root_abc = sdk2.parameters.String("Root abc (child of market_map)", required=True)
            with sdk2.parameters.RadioGroup("Environment", required=True) as environment:
                environment.values.unstable = None
                environment.values.testing = None
                environment.values.prestable = None
                environment.values.production = None
            layers = sdk2.parameters.Dict("App layers layer name/sandbox resource id")

            with sdk2.parameters.Output:
                result = sdk2.parameters.String("Result")

    def on_execute(self):
        arc = self._arc()
        project = str(self.Parameters.project_name)
        service = str(self.Parameters.service_name)
        config_dir = path.join("market/sre/conf/deplate/values", str(self.Parameters.root_abc).lower(),
                               str(self.Parameters.environment).lower())
        config_path = path.join(config_dir, "{}.yaml".format(service))

        with arc.mount_path("", "trunk", fetch_all=False) as mp:
            if self._run_command(["stage", "get", service], mp, valid_codes=[0, 2]) != 2:
                self.set_info("Stage {} already exists.".format(service))
                self.Parameters.result = Status.NOOP
                return
            cmd = ["stage", "create", config_path, "--abc", str(self.Parameters.root_abc), "--project", project]
            for layer, version in self.Parameters.layers.items():
                cmd.extend(["--layerver", "{}:{}".format(layer, version)])

            self._run_command(cmd, mp, assume_yes=True)

            self._run_command(["release_rules", "update", config_path], mp, assume_yes=True)

            self.Parameters.result = Status.CREATED
