# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects.market.sre.MarketDeplateRun import MarketDeplateRun


class Status(object):
    OK = "OK"
    ERROR = "ERROR"
    ACCESS_ERROR = "ACCESS_ERROR"
    ACCESS_MISSING = "ACCESS_MISSING"


class AccessWarning(Warning):
    pass


class AccessError(Exception):
    def __init__(self, exc):
        self.exc = exc


class MarketDeplateRunCreateProject(MarketDeplateRun):
    """
        Create Project with Deplate
    """

    class Parameters(MarketDeplateRun.Parameters):
        deplate_command = None

        with sdk2.parameters.Group("Deplate Create Project", collapse=False) as deplate_generate_block:
            project_name = sdk2.parameters.String("Project name", required=True)
            root_abc = sdk2.parameters.String("Root abc (child of market_map)", required=True)

            user_access = sdk2.parameters.Dict("User access user/role")
            abc_access = sdk2.parameters.Dict("Abc access abc:scope/role")

            check_access = sdk2.parameters.Bool("Check access if project exists", default=False)
            access_rules_only = sdk2.parameters.Bool("Skip creating project, just create access rules", default=False)

            with sdk2.parameters.Output:
                result = sdk2.parameters.String("Result")

    def _ok_result(self):
        self.Parameters.result = Status.OK

    def on_execute(self):
        try:
            abc_access = {}
            for k, v in self.Parameters.abc_access.items():
                parts = k.split(":")
                if len(parts) != 2:
                    raise ValueError("Invalid key format: {}".format(k))
                abc_access[parts[0]] = {"scope": parts[1], "role": v}

            arc = self._arc()
            project = str(self.Parameters.project_name)

            with arc.mount_path("", "trunk", fetch_all=False) as mp:
                if not self.Parameters.access_rules_only:
                    if self._run_command(["project", "get", project], mp, valid_codes=[0, 2]) != 2:
                        self.set_info("Project {} already exists.".format(project))

                        if self.Parameters.check_access and bool(0):
                            self.Parameters.status = Status.ACCESS_MISSING
                            raise AccessWarning("Some access missing")

                        return self._ok_result()

                    self._run_command(
                        ["project", "create", project, "--wait-for-idm", "--abc", str(self.Parameters.root_abc)], mp,
                        assume_yes=True)
                else:
                    self._run_command(["project", "wait-idm", project], mp)
                try:
                    for user, role in self.Parameters.user_access.items():
                        self._run_command(["project", "access", project, "--user", user, "--role", role], mp)

                    for abc, param in abc_access.items():
                        self._run_command(
                            ["project", "access", project, "--abc", abc, "--abc-scope", param["scope"], "--role",
                             param["role"]], mp)
                except Exception as exc:
                    raise AccessError(exc)

                return self._ok_result()

        except AccessWarning:
            self.Parameters.result = Status.ACCESS_MISSING
            raise

        except AccessError as exc:
            self.Parameters.result = Status.ACCESS_ERROR
            raise exc.exc

        except:
            self.Parameters.result = Status.ERROR
            raise
