# -*- coding: utf-8 -*-


from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import task


class InputText(parameters.SandboxStringParameter):
    name = 'input_test'
    description = 'Text to display'
    default_value = 'Hello World'


class MarketHelloWorld(task.SandboxTask):
    """
    A simple task that prints the text from SandboxStringParameter
    """

    type = 'MARKET_HELLO_WORLD'

    input_parameters = [
        InputText,
    ]

    def on_execute(self):
        self.set_info(self.ctx.get(InputText.name))


__task__ = MarketHelloWorld
