# coding=utf-8
import logging
import re

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment

class MarketTrackerTicketTagger(sdk2.Task):
    """
       Add tags and comments for ST
    """

    class Parameters(sdk2.Task.Parameters):
        _ = sdk2.parameters.Info("Документация: https://nda.ya.ru/3UXUUv")
        tasks_queue = sdk2.parameters.String("Очередь в Трекере", default="CSADMIN", required=False)
        tasks_author = sdk2.parameters.List("Автор тикета (имя пользователя)", required=True)

        with sdk2.parameters.Group("Параметры тегирования") as tagging_block:
            dict_tags = sdk2.parameters.Dict("Искомая подстрока: тег1,тег2,...", required=True)

        with sdk2.parameters.Group("Параметры комментирования") as comment_block:
            dict_comments = sdk2.parameters.Dict("Искомая подстрока: Комментарий к тикету", required=False)


    class Requirements(sdk2.Task.Requirements):
        environments = [
            PipEnvironment('startrek_client', custom_parameters=['requests==2.18.4'])
        ]


    def on_execute(self):
        if not self.Parameters.tasks_author:
            raise Exception("!! Author can not be empty !!")

        from startrek_client import Startrek

        # Auth
        oauth_token = sdk2.Vault.data("startrek_csadmin_token")
        st = Startrek(useragent="sandbox-market-tracker-ticket-tagger", token=oauth_token)

        # Create filter for issues
        st_filter = {
            "queue": self.Parameters.tasks_queue,
            "author": self.Parameters.tasks_author,
            "status": "open"
        }

        # Get issues
        issues = st.issues.find(filter=st_filter)

        # Process issues
        for issue in issues:
            tags_added = False
            for substr in self.Parameters.dict_tags.keys():
                tags_to_add = re.split(r", *", self.Parameters.dict_tags[substr])
                if substr == "*" or substr in issue.summary:
                    for tag_to_add in tags_to_add:
                        if not issue.tags:
                            issue.tags = [tag_to_add]
                            tags_added = True
                        elif not tag_to_add in issue.tags:
                            issue.tags.append(tag_to_add)
                            tags_added = True
            if tags_added:
                issue.update(tags=issue.tags)
                for substr in self.Parameters.dict_comments:
                    if substr == "*" or substr in issue.summary:
                        issue.comments.create(text=self.Parameters.dict_comments[substr])
