import os

import sandbox.common.types.client as ctc

import sandbox.projects.common.build.parameters as build_params
from sandbox.projects import resource_types
from sandbox.projects.common import utils
from sandbox.projects.common.build import YaMake
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk import parameters


class StartrekTicketIdsParameter(nanny.StartrekTicketIdsParameter):
    group = 'Other params'


class ArtifactDict(parameters.DictRepeater, parameters.SandboxStringParameter):
    name = 'artifact_dict'
    description = 'Build artifacts'

    @classmethod
    def get_custom_parameters(cls):
        return dict(
            values=sorted(((rt.name, rt.name) for rt in resource_types.AbstractResource if 'MARKET' in rt.name)))

    required = True
    group = build_params.BASE_BUILD_GROUP_NAME


class MarketYaMake(nanny.ReleaseToNannyTask, YaMake.YaMakeTask):
    '''A wrapper around YA_MAKE'''

    type = 'MARKET_YA_MAKE'

    input_parameters = [
        build_params.ArcadiaUrl,
        ArtifactDict,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.TestParameter,
        build_params.Sanitize,
        build_params.CheckoutParameter,
        StartrekTicketIdsParameter,
    ]

    execution_space = 60 * 1024  # 60 Gb
    cores = 24
    client_tags = ctc.Tag.Group.LINUX

    @property
    def artifact_dict(self):
        return utils.get_or_default(self.ctx, ArtifactDict)

    def get_resources(self):
        resources = {}
        for resource_path, resource_type in self.artifact_dict.iteritems():
            resource = {
                'description': resource_type,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_path),
            }
            resources[resource_type] = resource

        return resources

    def get_targets(self):
        return [resource_path for resource_path in self.artifact_dict.iterkeys()]

    def get_arts(self):
        return [{'path': resource_path} for resource_path in self.artifact_dict.iterkeys()]
