import logging

from sandbox.projects.market.sre.MarketYaPackageCommon import tsum
from sandbox.projects import resource_types
from sandbox.projects.common.build import YaPackage
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.projects.common.build import parameters as build_parameters


class StartrekTicketIdsParameter(nanny.StartrekTicketIdsParameter):
    group = 'Other params'


class TsumSendReportParameter(SandboxBoolParameter):
    name = 'tsum_send_report'
    description = 'Send report to TSUM'
    required = False
    default_value = False


class PackagesParameter(SandboxStringParameter):
    name = 'packages'
    description = 'Package path'
    required = True


class ResourceTtlParameter(SandboxStringParameter):
    name = 'resource_ttl'
    description = 'resource ttl'
    required = False
    default_value = 'inf'


class ResourceTypeParameter(SandboxStringParameter):
    name = 'resource_type'
    description = 'Resource type'
    required = True

    @classmethod
    def get_custom_parameters(cls):
        return dict(
            values=sorted(((rt.name, rt.name) for rt in resource_types.AbstractResource if 'MARKET' in rt.name)))


class MarketYaPackageLegacy(nanny.ReleaseToNannyTask, YaPackage.YaPackage):
    """
        Task for creating tarball packages using 'ya package'
    """

    type = 'MARKET_YA_PACKAGE_LEGACY'

    input_parameters = [
        YaPackage.parameters.ArcadiaUrl,
        YaPackage.parameters.ArcadiaPatch,
        YaPackage.parameters.UseArcadiaApiFuse,
        YaPackage.parameters.UseArcInsteadOfArcadiaApi,

        YaPackage.parameters.BuildSystem,
        YaPackage.parameters.BuildType,
        YaPackage.ClearBuildParameter,
        YaPackage.SemiClearBuildParameter,
        YaPackage.parameters.ForceVCSInfoUpdate,

        YaPackage.PackagesBlock,
        PackagesParameter,
        YaPackage.TestsBlock,
        YaPackage.RunTestsParameter,
        YaPackage.RunMediumTestsParameter,
        YaPackage.RunLongTestsParameter,
        YaPackage.IgnoreFailTestsParameter,
        YaPackage.ResourcesBlock,
        YaPackage.FullStripBinariesParameter,
        ResourceTypeParameter,
        StartrekTicketIdsParameter,
        TsumSendReportParameter,
        ResourceTtlParameter,
    ] + YaPackage.parameters.get_yt_store_params()

    def on_prepare(self):
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.TARBALL
        self.ctx[YaPackage.CompressPackageArchiveParameter.name] = True
        self.ctx[build_parameters.CheckoutParameter.name] = True

    def on_success(self):
        if self.ctx.get(TsumSendReportParameter.name):
            for resource in self.list_resources():
                if resource.type.releasable:
                    logging.info("Calculate md5 checksums for resource %s", resource.file_name)
                    tsum.send_report_to_tsum(resource.abs_path(), str(resource.type), self.id, resource.id)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        ttl = self.ctx.get(ResourceTtlParameter.name)
        if not ttl:
            ttl = 'inf'
        self.mark_released_resources(additional_parameters["release_status"], ttl)
