# coding: utf-8


import os
import logging
import shutil
from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from distutils.dir_util import copy_tree
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.market.sre.RunRenderMarketValidation import localrender


class RunNginxMarketValidation(sdk2.Task):
    """
    Checkout arcadia path to check template validation
    Checkout common resource with nginx common config
    Form right directory structure with them
    For each environment (ustable, testing. prestable, stable) render templates with nginx config
    Run nginx -t and yodax on prepared config

    """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl('Arcadia url', required=True)
        nginx_service_conf_url = sdk2.parameters.String('Path to service part of nginx configuration',
                                                            required=True)
        templates_dir = sdk2.parameters.String('Path to nginx templates directory', default='tmpl/conf/nginx',
                                               required=True)
        arcadia_patch = sdk2.parameters.String("Apply patch (text diff or rbtorrent)", multiline=True)
        _container = sdk2.parameters.Container('Environment container resource', default_value=501902488, required=True)

    def _prepare_tree(self):
        # checkout everythong from arcadia and combine valid config dir structure
        self.nginx_common_conf_url = sdk2.svn.Arcadia.ARCADIA_TRUNK_URL + '/market/sre/nanny/common/nginx/'
        self.nginx_front_common_conf_url = sdk2.svn.Arcadia.ARCADIA_TRUNK_URL + '/market/sre/nanny/front/common/nginx/'
        self.nginx_common_conf_dir = 'nginx-front-common-conf'
        self.nginx_front_common_conf_dir = 'nginx-common-conf'
        self.nginx_service_conf_dir = 'nginx-service-tmpl'
        self.templates_dir = 'templates'
        self.res_dir = 'result'
        for item in self.res_dir, self.templates_dir:
            os.mkdir(item)
        revision = sdk2.svn.Arcadia.parse_url(self.Parameters.checkout_arcadia_from_url).revision
        sdk2.svn.Arcadia.checkout(sdk2.svn.Arcadia.ARCADIA_TRUNK_URL + '/' +
                                  self.Parameters.nginx_service_conf_url, self.nginx_service_conf_dir, revision=revision)
        if self.Parameters.arcadia_patch:
            sdk2.svn.Arcadia.apply_patch(self.nginx_service_conf_dir, self.Parameters.arcadia_patch, os.path.abspath('.'))
        sdk2.svn.Arcadia.checkout(self.nginx_common_conf_url, self.nginx_common_conf_dir, revision=revision)
        sdk2.svn.Arcadia.checkout(self.nginx_front_common_conf_url, self.nginx_front_common_conf_dir, revision=revision)
        copy_tree(os.path.join(self.nginx_common_conf_dir, 'tmpl/conf/nginx'), self.templates_dir)
        copy_tree(os.path.join(self.nginx_common_conf_dir, 'conf/nginx'), self.templates_dir)
        copy_tree(os.path.join(self.nginx_service_conf_dir, self.Parameters.templates_dir), self.templates_dir)
        copy_tree(os.path.join(self.nginx_front_common_conf_dir, 'tmpl/conf/nginx'), self.templates_dir)
        shutil.copyfile(os.path.join(self.nginx_service_conf_dir, 'tmpl/variables.tmpl'), os.path.join(self.templates_dir, 'variables.tmpl'))
        logging.info('templates dir {}'.format(os.listdir(self.templates_dir)))

    def _prepare_packages(self):
        # an altrenative for self._prepare_tree() method
        # build tarballas with ya pacage, untar them and get valid config dir structure
        # not implemented yet
        self.nginx_common_conf_dir = 'nginx-common-conf'
        self.nginx_service_conf_dir = 'nginx-service-tmpl'
        self.templates_dir = 'tmpl'
        self.res_dir = 'result'
        build_tar_task = sdk2.Task['YA_PACKAGE']
        build_tar_task(self, description='Created from SDK2-task', parametes=sdk2.Parameters).enqueue()

    def on_execute(self):
        self._prepare_tree()
        logging.info('Trying to render templates with mocked values')
        default_conf = os.path.join(self.templates_dir, 'sites-enabled/default.conf')
        if os.path.exists(default_conf):
            os.remove(default_conf)
        localrender.render_templates(self.templates_dir, self.res_dir)
        logging.info('Rendering succeed')
        for env in localrender.ENVIRONMENT:
            out = os.listdir(os.path.join(self.res_dir, env, 'sites-enabled'))
            logging.info('Resulting files structure for {} is {}'.format(env, out))
            include = os.listdir(os.path.join(self.res_dir, env, 'include/hook'))
            logging.info('Resulting files structure for {} is {}'.format(env, include))
            prefix_dir = os.path.join(self.res_dir, env)
            nginx_cmd = 'ls -la /var/log/nginx/; nginx -p ' + prefix_dir + ' -c  nginx.conf -t'
            yodax_cmd = 'yodax -ll ' + os.path.join(prefix_dir, 'nginx.conf')
            with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('nginx_runner'), set_action=False) as pl:
                nginx_res = sp.Popen(nginx_cmd, shell=True,  stdout=pl.stdout, stderr=sp.STDOUT).wait()
                logging.info('Nginx run was {}'.format(nginx_res))
            with sdk2.helpers.ProcessLog(self, logger='yodax_result', set_action=False) as pl:
                yodax_res = sp.Popen(yodax_cmd, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
                logging.info('Yodax run was {}'.format(yodax_res))
            if nginx_res:
                raise TaskFailure('Nginx syntax check failed for {} environment'.format(env))
        self.set_info('Syntax checks passed successfully. Checkout "yodax_result" log file to see and fix yodax test results')
