# coding: utf-8


import os
import logging
from sandbox import sdk2
import localrender


class RunRenderMarketValidation(sdk2.Task):
    """
    Checkout arcadia path to check template validation
    For each environment (ustable, testing. prestable, stable) mock environment values and render templates
    The result -> rendered template files or error raised
    ---
    Then pack every set of templates to zip arch (?) via ya package (?)
    """

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl(required=True)
        templates_dir = sdk2.parameters.String('Path to templates directory', default='tmpl', required=True)

    def _clone_from_arcadia(self):
        logging.info('Clone arcadia repo from {} to {}'.format(self.Parameters.arcadia_url, self.arc_dir))
        try:
            sdk2.svn.Arcadia.checkout(self.Parameters.arcadia_url, self.arc_dir)
        except:
            logging.error("Can not clone arcadia repo")
            raise

    def on_execute(self):
        self.arc_dir = 'arc_dir'
        self.res_dir = 'result'
        self._clone_from_arcadia()
        try:
            logging.info("Trying to render templates with mocked values")
            localrender.render_templates(os.path.join(self.arc_dir, self.Parameters.templates_dir), self.res_dir)
            logging.info("Rendering succeed")
        except:
            logging.error("Rendering failed")
            raise
