#! /usr/bin/env python
# -*- coding: utf-8 -*-

import os
import socket
import jinja2
import logging

# TODO
# ygetparams отдавать адекватные значения

ENVIRONMENT = ['testing', 'prestable', 'production']

# данные взяты из dump.json/properties, НО там нет параметра BSCONFIG_IDIR!
env_vars = {
    "testing": {
        "BSCONFIG_IHOST": "vla1-5130",
        "BSCONFIG_INAME": "vla1-5130:26403",
        "BSCONFIG_IPORT": "26403",
        "BSCONFIG_ITAGS": "a_geo_vla a_topology_version-stable-104-r98 cgset_memory_recharge_on_pgfault_1 a_dc_vla a_line_vla-02 a_topology_cgset-memory.limit_in_bytes=12989759488 VLA_MARKET_TEST_FRONT_DESKTOP a_tier_none a_topology_stable-104-r98 a_metaprj_market a_itype_marketdesktop a_ctype_testing a_topology_group-VLA_MARKET_TEST_FRONT_DESKTOP a_prj_marketfront a_topology_cgset-memory.low_limit_in_bytes=12884901888 use_hq_spec enable_hq_report enable_hq_poll",
        "BSCONFIG_SHARDDIR": "./",
        "BSCONFIG_SHARDNAME": "",
        "BSCONFIG_IDIR": "/place/db/iss3/instances/8085_prestable_alemate_worker_t7nOlSnOA2F",
        "HQ_INSTANCE_SPEC_HASH": "04972a0fc4a4c88d482bc0055bede4e3",
        "JUGGLER_AGENT_PORT": "26410",
        "NANNY_SERVICE_ID": "testing_market_front_desktop_vla",
        "annotated_ports": "{}",
        "monitoringHostname": "vla1-5130.search.yandex.net",
        "monitoringInstanceName": "26403",
        "monitoringJugglerEndpoint": "http://localhost:26410/",
        "nanny_container_access_url": "http://nanny.yandex-team.ru/api/repo/CheckContainerAccess/",
        "tags": "a_geo_vla a_topology_version-stable-104-r98 cgset_memory_recharge_on_pgfault_1 a_dc_vla a_line_vla-02 a_topology_cgset-memory.limit_in_bytes=12989759488 VLA_MARKET_TEST_FRONT_DESKTOP a_tier_none a_topology_stable-104-r98 a_metaprj_market a_itype_marketdesktop a_ctype_testing a_topology_group-VLA_MARKET_TEST_FRONT_DESKTOP a_prj_marketfront a_topology_cgset-memory.low_limit_in_bytes=12884901888 use_hq_spec enable_hq_report enable_hq_poll"
    },
    "prestable": {
        "BSCONFIG_IHOST": "sas1-9640",
        "BSCONFIG_INAME": "sas1-9640:22650",
        "BSCONFIG_IPORT": "22650",
        "BSCONFIG_ITAGS": "a_topology_stable-101-r157 a_line_sas-2.3.1 a_geo_sas a_topology_version-stable-101-r157 SAS_MARKET_PREP_FRONT_DESKTOP a_prj_marketfront a_tier_none a_metaprj_market a_itype_marketdesktop a_ctype_prestable a_dc_sas a_topology_group-SAS_MARKET_PREP_FRONT_DESKTOP use_hq_spec enable_hq_report enable_hq_poll",
        "BSCONFIG_SHARDDIR": "./",
        "BSCONFIG_SHARDNAME": "",
        "BSCONFIG_IDIR": "/place/db/iss3/instances/8085_prestable_alemate_worker_t7nOlSnOA2F",
        "HQ_INSTANCE_SPEC_HASH": "a0ae956f06aa537e1410c3088e0d4c11",
        "JUGGLER_AGENT_PORT": "22657",
        "NANNY_SERVICE_ID": "prestable_market_front_desktop_sas",
        "annotated_ports": "{}",
        "monitoringHostname": "sas1-9640.search.yandex.net",
        "monitoringInstanceName": "22650",
        "monitoringJugglerEndpoint": "http://localhost:22657/",
        "nanny_container_access_url": "http://nanny.yandex-team.ru/api/repo/CheckContainerAccess/",
        "tags": "a_topology_stable-101-r157 a_line_sas-2.3.1 a_geo_sas a_topology_version-stable-101-r157 SAS_MARKET_PREP_FRONT_DESKTOP a_prj_marketfront a_tier_none a_metaprj_market a_itype_marketdesktop a_ctype_prestable a_dc_sas a_topology_group-SAS_MARKET_PREP_FRONT_DESKTOP use_hq_spec enable_hq_report enable_hq_poll"
    },
    "production": {
        "BSCONFIG_IHOST": "iva1-1719",
        "BSCONFIG_INAME": "iva1-1719:24528",
        "BSCONFIG_IPORT": "24528",
        "BSCONFIG_ITAGS": "IVA_MARKET_PROD_FRONT_ABO a_ctype_production a_dc_iva a_geo_msk a_itype_marketfrontabo a_line_iva-2 a_metaprj_market a_prj_market a_tier_none a_topology_cgset-memory.limit_in_bytes=12989759488 a_topology_cgset-memory.low_limit_in_bytes=12884901888 a_topology_group-IVA_MARKET_PROD_FRONT_ABO a_topology_stable-104-r404 a_topology_version-stable-104-r404 cgset_memory_recharge_on_pgfault_1 use_hq_spec enable_hq_report enable_hq_poll",
        "BSCONFIG_SHARDDIR": "./",
        "BSCONFIG_SHARDNAME": "",
        "BSCONFIG_IDIR": "/place/db/iss3/instances/8085_prestable_alemate_worker_t7nOlSnOA2F",
        "HOSTNAME": "iva1-1719-iva-market-prod-front-abo-24528.gencfg-c.yandex.net",
        "HQ_INSTANCE_SPEC_HASH": "ed90d04b823ff59ddc102d098a506de8",
        "NANNY_SERVICE_ID": "production_market_front_abo_iva",
        "NODE_NAME": "iva1-1719.search.yandex.net",
        "annotated_ports": "{}",
        "nanny_container_access_url": "http://nanny.yandex-team.ru/api/repo/CheckContainerAccess/",
        "tags": "IVA_MARKET_PROD_FRONT_ABO a_ctype_production a_dc_iva a_geo_msk a_itype_marketfrontabo a_line_iva-2 a_metaprj_market a_prj_market a_tier_none a_topology_cgset-memory.limit_in_bytes=12989759488 a_topology_cgset-memory.low_limit_in_bytes=12884901888 a_topology_group-IVA_MARKET_PROD_FRONT_ABO a_topology_stable-104-r404 a_topology_version-stable-104-r404 cgset_memory_recharge_on_pgfault_1 use_hq_spec enable_hq_report enable_hq_poll"
        }
}


class Env(dict):
    def __init__(self, data=None, **kwargs):
        super(Env, self).__init__(**kwargs)
        self.data = dict() if data is None else data

    def __getattr__(self, name):
        if self.data[name].isdigit():
            return int(self.data[name])
        return self.data[name]


def short_hostname(hostname):
    ''' str -> str
    '''
    return hostname.split(".")[0]


# MockThemRight
def ygetparam_instance(service, param):
    ''' str, str -> tuple
    Return param from  manifest retrived by a service name.
    '''
    return ("ygetparam_instance", "mocked_tuple")


def ygetparam_manifest(file_name, param):
    ''' str, str -> str
    Load json and pass thru ygetparam
    '''
    return ("ygetparam_manifest", "mocked_tuple")


def ygetparam_module(module_name, string):
    ''' str, str -> str
    Load json and pass thru ygetparam
    '''
    return "ygetparam_module_mocked_string"


svc = {"name": "_".join(os.path.basename(os.path.abspath(".")).split("_")[1:-1]),
       "work_directory": os.path.abspath("."),
       "current_host": socket.gethostname()}


def funcs_env(env):
    funcs = {'env': Env(env_vars[env]),
             'ygetparam': ygetparam_instance,
             'ygetparam_module': ygetparam_module,
             'ygetparam_manifest': ygetparam_manifest,
             'svc': Env(svc),
             'short_hostname': short_hostname
             }
    return funcs


def _write_file(dst, template, rendered_file):
    full_file_path = os.path.join(dst, template)
    dir_name = os.path.dirname(full_file_path)
    if not os.path.exists(dir_name):
        os.makedirs(dir_name)
    with open(full_file_path, 'w') as f:
        f.write(rendered_file.encode('utf-8'))


def render_templates(dir, res_dir):
    loader = jinja2.FileSystemLoader(dir)
    templates = jinja2.Environment(loader=loader, undefined=jinja2.StrictUndefined)

    for item in templates.list_templates(filter_func=lambda x: x not in ('README.md', 'variables.tmpl')):
        logging.info("Processing file: {}".format(item))
        template = templates.get_template(item)
        for env in ENVIRONMENT:
            logging.info("Rendering {} for environment {}".format(item, env))
            dst_dir = os.path.join(res_dir, env)
            _write_file(dst_dir, item, template.render(funcs_env(env)))


if __name__ == '__main__':
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s: %(message)s')
    logHandler = logging.StreamHandler()
    logHandler.setFormatter(formatter)
    logger.addHandler(logHandler)
    render_templates('.', 'res')
