import json
import sys

from sandbox import sdk2
from sandbox.sandboxsdk import svn


CLICKHOUSE_DB = 'market'
CLICKHOUSE_ADDR = 'health-house.market.yandex.net'
CLICKHOUSE_SECRET_NAME = 'googlebot_cache_warmer_clickhouse_credentials'
CLICKHOUSE_SECRET_OWNER = 'MARKETSRE'


class BaseGooglebotTask(sdk2.Task):
    @property
    def clickhouse(self):
        if hasattr(self, '_clickhouse'):
            return self._clickhouse

        sys.path.append(svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/contrib/python/clickhouse-driver"))

        from clickhouse_driver import Client

        secret = sdk2.Vault.data(CLICKHOUSE_SECRET_OWNER, CLICKHOUSE_SECRET_NAME)
        clickhouse_credentials = json.loads(secret)
        self._clickhouse = Client(
            CLICKHOUSE_ADDR,
            user=clickhouse_credentials['login'],
            password=clickhouse_credentials['password'],
            database=CLICKHOUSE_DB,
        )
        return self._clickhouse

    def clickhouse_execute(self, query, args=None):
        result = self.clickhouse.execute(query, args)
        return result

    def on_execute(self):
        raise NotImplementedError
