# coding=utf-8

import codecs
import logging
from random import choice
from string import ascii_lowercase

from sandbox.projects.market.stock_storage.ammo_generator import make_ammo, get_ammo_string


class FreezeStocksGenerator:
    class Parameters:
        ss_url = 'https://bos.tst.vs.market.yandex.net'
        stocks_in_ammo = 5
        vendor_ids = [2]
        warehouse_ids = [1]
        orders_amount = 100000
        get_available_by_order_ratio = 3

    class Constants:
        def __init__(self):
            pass

        ITEM_TEMPLATE = '{"shopSku":"load-test-sku-%s", "vendorId": %s, "warehouseId":%s},'
        ORDER_ITEMS_TEMPLATE = '{"item": %s "amount":1, "backorder":false},'
        GET_AVAILABLE_TEMPLATE = '{"items": [%s]}'
        ORDER_TEMPLATE = '{"orderId": "load-test-order-%s-%s-%s", "items": [%s], "freezeVersion": 0}'
        UNFREEZE_TEMPLATE = 'load-test-order-%s-%s-%s?delay=1200'

    def on_execute(self):
        freeze_ammo = self.get_available_and_freeze_generator()
        ammo = get_ammo_string(freeze_ammo)

        with codecs.open('freeze_stocks.txt', 'w', encoding='utf-8') as f:
            f.write(ammo)

    def get_available_and_freeze_generator(self):
        ammos = []
        stocks = self.Parameters.orders_amount * self.Parameters.get_available_by_order_ratio * self.Parameters.stocks_in_ammo

        logging.info(
            '''Params for freeze:
            ss_url = {}
            stocks_in_ammo = {}
            vendor_ids = {}
            warehouse_ids = {}
            orders_amount = {}
            get_available_by_order_ratio = {}
            stocks = {}
            '''.format(self.Parameters.ss_url, self.Parameters.stocks_in_ammo, self.Parameters.vendor_ids,
                       self.Parameters.warehouse_ids, self.Parameters.orders_amount,
                       self.Parameters.get_available_by_order_ratio, stocks)
        )

        for vendor_id in self.Parameters.vendor_ids:
            for warehouse_id in self.Parameters.warehouse_ids:
                stock_id = 0
                order_number = 0
                logging.info(
                    'Start generate freeze ammo for vendor_id={} and warehouse_id={}'.format(vendor_id, warehouse_id))
                while stock_id <= stocks:
                    order_number += 1
                    get_available_item = ''
                    order_item = ''
                    ammo = ''
                    if order_number % 1000 == 0:
                        logging.info('Generated {} freeze ammo. stock_id={}'.format(order_number, stock_id))

                    for stock_id in range(stock_id + 1, stock_id + self.Parameters.stocks_in_ammo + 1):
                        item = self.Constants.ITEM_TEMPLATE % (stock_id, vendor_id, warehouse_id)
                        get_available_item += item
                        order_item += self.Constants.ORDER_ITEMS_TEMPLATE % item

                    get_available_request = self.Constants.GET_AVAILABLE_TEMPLATE % (get_available_item[:-1])
                    ammo += (make_ammo(self.Parameters.ss_url, 'POST',
                                       '/order/getAvailableAmounts', 'getAvailableAmounts', get_available_request))

                    if order_number % self.Parameters.get_available_by_order_ratio == 0:
                        order_id = (''.join(choice(ascii_lowercase) for i in range(20)))
                        order_ammo_request = self.Constants.ORDER_TEMPLATE % (vendor_id, warehouse_id,
                                                                              order_id, order_item[:-1])
                        ammo += (make_ammo(self.Parameters.ss_url, 'POST',
                                           '/order', 'freeze', order_ammo_request))

                        ammo += (make_ammo(self.Parameters.ss_url, 'DELETE',
                                           '/order/' + self.Constants.UNFREEZE_TEMPLATE % (vendor_id, warehouse_id,
                                                                                           order_id), 'unfreeze', ''))
                    ammos.append(ammo)
        return ammos
