# coding=utf-8

import codecs
import logging
import random
from datetime import date

from sandbox.projects.market.stock_storage.ammo_generator import make_ammo, get_ammo_string


class PushStocksGenerator:
    class Parameters:
        ss_url = 'https://bos.tst.vs.market.yandex.net'
        stocks_in_ammo = 5
        vendor_ids = [2]
        warehouse_ids = [1]
        stocks_amount = 150000

    class Constants:
        def __init__(self):
            pass

        UNIT_ID_TEMPLATE = '"unitId": {"vendorId": %s,"article": "load-test-sku-%s"}'
        WAREHOUSE_TEMPLATE = '"warehouseId": {"yandexId": %s,"fulfillmentId": %s}'
        STOCKS_TEMPLATE = '"stocks": [' \
                          '{"type": 10,"count": 5000%s,"updated": "%s"},' \
                          '{"type": 20,"count": 1000%s,"updated": "%s"}' \
                          ']'
        SOURCE_TEMPLATE = '"source": {"warehouseId": %s}'
        STOCKS_DATA_TEMPLATE = '{%s,%s,%s},'
        REQUEST_TEMPLATE = '{"itemStocks": [%s],%s}'

    def on_execute(self):
        stocks_ammo = self.generate_push_stocks()
        ammo = get_ammo_string(stocks_ammo)

        with codecs.open('push_stocks.txt', 'w', encoding='utf-8') as f:
            f.write(ammo)

    def generate_push_stocks(self):
        today = date.today()
        stocks_ammo = []
        aggregated_stocks_amount = self.Parameters.stocks_amount * self.Parameters.stocks_in_ammo
        logging.info(
            '''Params for pushStocks:
            ss_url = {}
            stocks_in_ammo = {}
            vendor_ids = {}
            warehouse_ids = {}
            stocks_amount = {}
            aggregated_stocks_amount = {}
            '''.format(self.Parameters.ss_url, self.Parameters.stocks_in_ammo, self.Parameters.vendor_ids,
                       self.Parameters.warehouse_ids, self.Parameters.stocks_amount, aggregated_stocks_amount)
        )

        for vendor_id in self.Parameters.vendor_ids:
            for warehouse_id in self.Parameters.warehouse_ids:
                stock_id = 0
                logging.info('Start generate pushStocks ammo for vendor_id={} and warehouse_id={}'.format(vendor_id,
                                                                                                          warehouse_id))
                while stock_id < aggregated_stocks_amount:
                    stocks_data = ''
                    if stock_id % 1000 == 0:
                        logging.info('Generated pushStocks {} ammo.'.format(stock_id))

                    for stock_id in range(stock_id + 1, stock_id + self.Parameters.stocks_in_ammo + 1):
                        unit_id = self.Constants.UNIT_ID_TEMPLATE % (vendor_id, stock_id)
                        stocks = self.Constants.STOCKS_TEMPLATE % (random.randint(1, 100), today,
                                                                   random.randint(1, 100), today)
                        warehouse = self.Constants.WAREHOUSE_TEMPLATE % (warehouse_id, warehouse_id)
                        stocks_data += self.Constants.STOCKS_DATA_TEMPLATE % (unit_id, warehouse, stocks)

                    source = self.Constants.SOURCE_TEMPLATE % warehouse_id
                    request = self.Constants.REQUEST_TEMPLATE % (stocks_data[:-1], source)
                    stocks_ammo.append(make_ammo(self.Parameters.ss_url, 'POST', '/stocks', 'pushStocks', request))
        return stocks_ammo
