# -*- coding: utf-8 -*-

import os
import logging
from sandbox import sdk2
from sandbox.projects.market.resources import MARKET_TICKETS_SUMMONEER_APP
from sandbox.projects.market.front.helpers.sandbox_helpers import rich_check_call


class TicketsSummoneer(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ENV_NAME = sdk2.parameters.String(
            "environment",
            default_value="Testing"
        )
        FEMIDA_ID = sdk2.parameters.String(
            "FEMIDA_ID",
            default_value=""
        )
        STAFF_TOKEN_VAULT_NAME = sdk2.parameters.String(
            "STAFF_TOKEN_VAULT_NAME",
            default_value=""
        )
        TRACKER_TOKEN_VAULT_NAME = sdk2.parameters.String(
            "TRACKER_TOKEN_VAULT_NAME",
            default_value=""
        )
        TRACKER_QUEUE = sdk2.parameters.String(
            "TRACKER_QUEUE",
            default_value="MARKETJOBTEST"
        )

    def on_execute(self):
        resource = sdk2.Resource.find(resource_type=MARKET_TICKETS_SUMMONEER_APP).order(-sdk2.Resource.id).first()
        binary_path = str(sdk2.ResourceData(resource).path)

        my_env = os.environ.copy()
        my_env["SCRIPT_ENV"] = self.Parameters.ENV_NAME
        my_env["FEMIDA_ID"] = self.Parameters.FEMIDA_ID
        my_env["TRACKER_QUEUE"] = self.Parameters.TRACKER_QUEUE
        my_env["TRACKER_TOKEN"] = sdk2.Vault.data(self.Parameters.TRACKER_TOKEN_VAULT_NAME)
        my_env["STAFF_TOKEN"] = sdk2.Vault.data(self.Parameters.STAFF_TOKEN_VAULT_NAME)
        my_env["LOG_PATH"] = str(self.log_path())

        rich_check_call([binary_path + "/app"], task=self, alias="tickets_summoneer", env=my_env)

        logging.info("SUCCESS")
