import const
import ammo
import codecs
import os.path

from sandbox import sdk2
from sandbox.projects.market.tpl.resources import PvzIntLoadAmmo
from sandbox.projects.market.tpl.resources import PvzIntLoadConfig

orders_per_status_per_pp = 200
default_profile = {
    # ds api
    ammo.create_order: 0.83,
    ammo.update_order: 1.60,
    ammo.get_order_status: 15,
    ammo.get_order_history: 65,
    # partner
    ammo.get_order_list: 0.28,
    ammo.deliver_order: 0.83,
}

config_yaml_template = 'config/check.yaml.template'

def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string

class MarketPvzIntLoadGenerateAmmo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)


    def on_execute(self):
        self.generate_ammo()
        self.generate_config()


    def generate_ammo(self):
        bullet_count = self.Parameters.bullet_count
        ammo_text = ammo.generate_ammo(bullet_count, orders_per_status_per_pp, default_profile)

        data = sdk2.ResourceData(
            PvzIntLoadAmmo(self, 'PvzInt load ammo', 'ammo.txt')
        )
        with codecs.open('ammo.txt', 'w', encoding='utf-8') as f:
            f.write(ammo_text)
        data.ready()


    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            PvzIntLoadConfig(self, 'PvzInt load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule = self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()
