import random
from uuid import uuid4
from datetime import date

import sandbox.projects.market.tpl.common.ds_api as ds_api
import sandbox.projects.market.tpl.common.pvz_int_client as pvz_int_client

to_receive_status = 'CREATED'
to_deliver_status = 'ARRIVED_TO_PICKUP_POINT'

pvz_int_host = 'pvz-int.tst.vs.market.yandex.net'
partner_id = 1001073997

pvz_int = pvz_int_client.PvzIntClient(pvz_int_host)
ds_api_client = ds_api.DSApiClient(
    pvz_int_host,
    '/delivery/query-gateway',
    'load-test-token'
)

orders_external_id_for_get = []
orders_to_receive = []
orders_to_deliver = []

pickup_points = [
    {
        'id': 2,
        'pvzMarketId': 1001075209
    },
    {
        'id': 3,
        'pvzMarketId': 1001075332
    },
    {
        'id': 4,
        'pvzMarketId': 1001077918
    }
]

def bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)

def order_yandex_id():
    return 'load-test-' + str(uuid4())

def random_pickup_point_id():
    return random.choice(pickup_points)['id']

def get_pickup_points():
    response = pvz_int.get_pickup_points(partner_id)
    pickup_points.extend([ pvz for pvz in response['content'] if 'pvzMarketId' in pvz and pvz['requestStatus'] == 'APPROVED' ])
    print('pickup points: ' + str(pickup_points))

def create_orders(pvzMarketId, status, count):
    orders = pvz_int.create_orders_in_status(pvzMarketId, count, status)
    return [ {
        'id': order['id'],
        'externalId': order['externalId'],
        'pvzMarketId': pvzMarketId
    } for order in orders ]

def generate_orders_for_get(count):
    for pp in pickup_points:
        pvzMarketId = pp['pvzMarketId']

        to_receive_orders = create_orders(pvzMarketId, to_receive_status, count)
        to_deliver_orders = create_orders(pvzMarketId, to_deliver_status, count)

        orders_to_receive.extend(to_receive_orders)
        orders_to_deliver.extend(to_deliver_orders)

    orders_external_id_for_get.extend([ order['externalId'] for order in orders_to_receive ])
    orders_external_id_for_get.extend([ order['externalId'] for order in orders_to_receive ])

def get_request_text(endpoint):
    headers = {
        'Host': pvz_int_host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*'
    }
    return 'GET ' + endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers.items()]) + '\r\n'

def post_request_text(endpoint, body):
    headers = {
        'Host': pvz_int_host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Type': 'application/json',
        'Content-Encoding': 'utf-8',
        'Content-Length': str(len(body.encode('utf-8')))
    }
    return 'POST ' + endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers.items()]) + '\r\n' + body + '\r\n'


def create_order():
    return bullet(ds_api_client.request_text(ds_api.create_order_body(
        ds_api_client.token,
        order_yandex_id(),
        random_pickup_point_id()
    ), 'createOrder'), 'createOrder')

def update_order():
    yandex_id = order_yandex_id()
    pickup_point_id = random_pickup_point_id()

    ds_api_client.create_order(yandex_id, pickup_point_id)
    orders_external_id_for_get.append(yandex_id)
    return bullet(ds_api_client.request_text(ds_api.update_order_body(
        ds_api_client.token,
        yandex_id
    ), 'updateOrder'), 'updateOrder')

def get_order_status():
    yandex_ids = random.sample(orders_external_id_for_get, 60)
    return bullet(ds_api_client.request_text(ds_api.get_order_status_body(
        ds_api_client.token,
        yandex_ids
    ), 'getOrdersStatus'), 'getOrdersStatus')

def get_order_history():
    yandex_id = random.choice(orders_external_id_for_get)
    return bullet(ds_api_client.request_text(ds_api.get_order_history_body(
        ds_api_client.token,
        yandex_id
    ), 'getOrderHistory'), 'getOrderHistory')

#/v1/pi/pickup-points/1001077918/orders?deliveryDateLessThanOrEqual=2021-02-12&shipmentStatus=TO_RECEIVE&size=500&page=0
def get_order_list():
    pvz = random.choice(pickup_points)
    return bullet(
        get_request_text('/v1/pi/pickup-points/{}/orders?shipmentStatus=TO_RECEIVE&size=500&page=0'.format(pvz['pvzMarketId'])),
        'GET_pickup-points_orders'
    )

def deliver_order():
    order = random.choice(orders_to_deliver)
    orders_to_deliver.remove(order)
    return bullet(
        post_request_text(
            '/v1/pi/pickup-points/{}/orders/{}/deliver'.format(order['pvzMarketId'], order['id']),
            '{ "paymentType": "CARD" }'
        ),
        'POST_v1_pi_pickup-points_pvzMarketId_orders_id_deliver'
    )
    pass

def generate_ammo(bullet_count, orders_per_status_per_pp, profile):
    generate_orders_for_get(orders_per_status_per_pp)
    profile_total = sum([value for (key, value) in profile.items()])
    single_bullet_count = bullet_count/profile_total
    bullets = [[key() for x in range(0, int(single_bullet_count*value))] for (key, value) in profile.items()]
    bullets = [item for sublist in bullets for item in sublist]
    random.shuffle(bullets)
    return '\n'.join(bullets)
