import const
import ammo
import codecs
import os.path

from sandbox import sdk2
from sandbox.projects.market.tpl.resources import ScApiLoadAmmo
from sandbox.projects.market.tpl.resources import ScApiLoadConfig


default_profile = {
    ammo.get_order: 50,
    ammo.accept_order: 50,
    ammo.check_user: 50,
    ammo.sort_order: 50,
    ammo.get_routes: 5,
    ammo.finish_route: 5
    #ammo.get_routes_all: 1
    #ammo.get_cells_total: 1,
    #ammo.get_cells_sort: 1,
    #ammo.get_cell: 1
}

config_yaml_template = 'config/check.yaml.template'

def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string

class MarketScApiLoadGenerateAmmo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)


    def on_execute(self):
        self.generate_ammo()
        self.generate_config()


    def generate_ammo(self):
        bullet_count = self.Parameters.bullet_count
        ammo_text = ammo.generate_ammo(bullet_count, default_profile)

        data = sdk2.ResourceData(
            ScApiLoadAmmo(self, 'ScApi load ammo', 'ammo.txt')
        )
        with codecs.open('ammo.txt', 'w', encoding='utf-8') as f:
            f.write(ammo_text)
        data.ready()


    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            ScApiLoadConfig(self, 'ScApi load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule = self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()
