import random
import time
from uuid import uuid4

import json

import sandbox.projects.market.tpl.common.ff_api as ff_api
import sandbox.projects.market.tpl.common.sc_int_client as sc_int


stockman_tkn = 'AAAABC98OOAAY7wFe8LwvBh00cv8o9tIszIUA'

sc_api_host = 'sc-api.tst.vs.market.yandex.net'

sc_int_host = 'sc-int.tst.vs.market.yandex.net'

ff_api_client = ff_api.FFApiClient(
    sc_int_host,
    '/fulfillment/query-gateway',
    'load-test-token'
)

sc_int_client = sc_int.ScIntClient(sc_int_host)

def bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)

def order_yandex_id():
    return 'load-test-' + str(uuid4())


orders_pool = []
sort_order_ind = 0

def generate_orders_pool():
    for i in range(200):
        yandex_id = order_yandex_id()
        ff_api_client.create_order(yandex_id)
        ff_api_client.update_order(yandex_id)
        orders_pool.append(yandex_id)
    global sort_order_ind
    sort_order_ind = 0


def get_request_text(endpoint):
    headers = {
        'Host': sc_api_host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Authorization': 'OAuth Ag' + stockman_tkn
    }
    return 'GET ' + endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers.items()]) + '\r\n'

def body_request_text(method, endpoint, body):
    headers = {
        'Host': sc_api_host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Type': 'application/json',
        'Content-Encoding': 'utf-8',
        'Content-Length': str(len(body.encode('utf-8'))),
        'Authorization': 'OAuth Ag' + stockman_tkn
    }
    return method + ' ' + endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers.items()]) + '\r\n' + body.encode('utf-8') + '\r\n'


def get_order():
    yandex_id = random.choice(orders_pool)
    return bullet(
        get_request_text('/api/orders?externalId={}'.format(yandex_id)),
        'GET_api_orders'
    )

def accept_order():
    yandex_id = random.choice(orders_pool)
    return bullet(
        body_request_text('PUT', '/api/orders/accept', '{{"externalId":"{}"}}'.format(yandex_id)),
        'PUT_api_orders_accept'
    )

def sort_order():
    global sort_order_ind
    yandex_id = orders_pool[sort_order_ind]
    sort_order_ind = sort_order_ind + 1
    if len(orders_pool) >= sort_order_ind:
        sort_order_ind = 0
    sc_int_client.accept_order(yandex_id)
    order = json.loads(sc_int_client.get_order(yandex_id))
    order_id = order['id']
    cell_id = order['availableCells'][0]['id']
    return bullet(
        body_request_text('PUT', '/api/orders/{}'.format(order_id), '{{"cellId":"{}"}}'.format(str(cell_id))),
        'PUT_api_orders'
    )

def get_routes():
    return bullet(
        get_request_text('/api/routes?routeType=OUTGOING_COURIER&courierId={}'.format(random.choice(ff_api.courier_pool))),
        'GET_api_routes'
    )

def get_routes_all():
    return bullet(
        get_request_text('/api/routes?routeType=OUTGOING_COURIER'),
        'GET_api_routes_all'
    )

courier_pool = range(100,200)

def finish_route():
    yandex_id = order_yandex_id()
    ff_api_client.create_order(yandex_id)
    courier_id = random.choice(courier_pool)
    ff_api_client.update_order_courier(yandex_id, courier_id)
    route_id = ''
    for i in range(3):
        route = json.loads(sc_int_client.get_route(courier_id))
        if len(route) > 0 and 'id' in route[0]:
            route_id = route[0]['id']
            break
        time.sleep(2)
    cell_id = route[0]['cells'][0]['id']
    return bullet(
        body_request_text('PUT', '/api/routes/{}'.format(route_id), '{{"cellId":"{}"}}'.format(str(cell_id))),
        'PUT_api_routes'
    )

def check_user():
    return bullet(get_request_text('/api/checkUser'), 'GET_api_check_user')

def get_cells_total():
    return bullet(get_request_text('/api/cells/sort/total'), 'GET_api_cells_sort_total')

def get_cells_sort():
    return bullet(get_request_text('/api/cells/sort'), 'GET_api_cells_sort')

def get_cell():
    yandex_id = order_yandex_id()
    ff_api_client.create_order(yandex_id)
    ff_api_client.update_order(yandex_id)
    sc_int_client.accept_order(yandex_id)
    sc_int_client.sort_order(yandex_id)
    order = json.loads(sc_int_client.get_order(yandex_id))
    cell_id = order['cell']['id']
    return bullet(
        get_request_text('/api/cells/{}'.format(cell_id)),
        'GET_api_cells'
    )


def generate_ammo(bullet_count, profile):
    generate_orders_pool()
    profile_total = sum([value for (key, value) in profile.items()])
    single_bullet_count = bullet_count/profile_total
    bullets = [[key() for x in range(0, int(single_bullet_count*value))] for (key, value) in profile.items()]
    bullets = [item for sublist in bullets for item in sublist]
    random.shuffle(bullets)
    return '\n'.join(bullets)
