import const
import ammo
import codecs
import os.path

from sandbox import sdk2
from sandbox.projects.market.tpl.resources import ScIntLoadAmmo
from sandbox.projects.market.tpl.resources import ScIncLoadConfig


default_profile = {
    # ff api
    ammo.create_order: 10,
    ammo.update_order: 10,
    ammo.cancel_order: 1,
    ammo.return_order: 1,
    ammo.get_order_status: 10,
    ammo.get_order_history: 10,

    # partner api
    ammo.get_routes: 10
}

config_yaml_template = 'config/check.yaml.template'

def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string

class MarketScIntLoadGenerateAmmo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)


    def on_execute(self):
        self.generate_ammo()
        self.generate_config()


    def generate_ammo(self):
        bullet_count = self.Parameters.bullet_count
        ammo_text = ammo.generate_ammo(bullet_count, default_profile)

        data = sdk2.ResourceData(
            ScIntLoadAmmo(self, 'ScInt load ammo', 'ammo.txt')
        )
        with codecs.open('ammo.txt', 'w', encoding='utf-8') as f:
            f.write(ammo_text)
        data.ready()


    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            ScIncLoadConfig(self, 'ScInt load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule = self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()