import random
from uuid import uuid4
from datetime import date

import sandbox.projects.market.tpl.common.ff_api as ff_api
import sandbox.projects.market.tpl.common.sc_int_client as sc_int

sc_int_host = 'sc-int.tst.vs.market.yandex.net'

ff_api_client = ff_api.FFApiClient(
    sc_int_host,
    '/fulfillment/query-gateway',
    'load-test-token'
)

sc_int_client = sc_int.ScIntClient(sc_int_host)

def bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)

def order_yandex_id():
    return 'load-test-' + str(uuid4())


orders_for_get = []

def generate_orders_for_get():
    for i in range(100):
        yandex_id = order_yandex_id()
        ff_api_client.create_order(yandex_id)
        orders_for_get.append(yandex_id)


def get_request_text(endpoint):
    headers = {
        'Host': sc_int_host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*'
    }
    return 'GET ' + endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers.items()]) + '\r\n'



def get_routes():
    return bullet(get_request_text(
        '/internal/partners/123/routes?date={}'.format(str(date.today())) + 
        '&type=INCOMING_WAREHOUSE&type=OUTGOING_WAREHOUSE' +
        '&type=INCOMING_COURIER&type=OUTGOING_COURIER'
    ), 'GET_internal_partners_routes')

def create_order():
    return bullet(ff_api_client.request_text(ff_api.create_order_body(
        ff_api_client.token,
        order_yandex_id()
    )), 'createOrder')

def update_order():
    yandex_id = order_yandex_id()
    ff_api_client.create_order(yandex_id)
    orders_for_get.append(yandex_id)
    return bullet(ff_api_client.request_text(ff_api.update_order_body(
        ff_api_client.token,
        yandex_id
    )), 'updateOrder')

def cancel_order():
    yandex_id = order_yandex_id()
    ff_api_client.create_order(yandex_id)
    orders_for_get.append(yandex_id)
    return bullet(ff_api_client.request_text(ff_api.cancel_order_body(
        ff_api_client.token,
        yandex_id
    )), 'cancelOrder')

def return_order():
    yandex_id = order_yandex_id()
    ff_api_client.create_order(yandex_id)
    ff_api_client.update_order(yandex_id)
    sc_int_client.accept_order(yandex_id)
    orders_for_get.append(yandex_id)
    return bullet(ff_api_client.request_text(ff_api.return_order_body(
        ff_api_client.token,
        yandex_id
    )), 'createReturnRegister')

def get_order_status():
    yandex_ids = random.sample(orders_for_get, 20)
    return bullet(ff_api_client.request_text(ff_api.get_order_status_body(
        ff_api_client.token,
        yandex_ids
    )), 'getOrdersStatus')

def get_order_history():
    yandex_id = random.choice(orders_for_get)
    return bullet(ff_api_client.request_text(ff_api.get_order_history_body(
        ff_api_client.token,
        yandex_id
    )), 'getOrderHistory')



def generate_ammo(bullet_count, profile):
    generate_orders_for_get()
    profile_total = sum([value for (key, value) in profile.items()])
    single_bullet_count = bullet_count/profile_total
    bullets = [[key() for x in range(0, single_bullet_count*value)] for (key, value) in profile.items()]
    bullets = [item for sublist in bullets for item in sublist]
    random.shuffle(bullets)
    return '\n'.join(bullets)
