import const
import ammo
import request_log_parser
import codecs

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sdk2 import (Resource)

from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task

from tpl_db import TplDB
from tpl_api_request_definitions import RequestDefinitionService

config_yaml_template = 'config/check.yaml.template'


def get_resource(file_name):
    from library.python import resource
    return resource.find(file_name)


def get_raw_request_definitions(request_logs_resource):
    data_path = str(sdk2.ResourceData(request_logs_resource).path)
    with open(data_path) as file:
        return request_log_parser.parse(file)


class MarketTplApiLoadGenerateAmmo(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)
        host = sdk2.parameters.String('Host', default=const.HOST)
        ext_params = binary_task.binary_release_parameters(stable=True)

    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "task_type": "MARKET_TPL_API_LOAD_GENERATE_AMMO",
                "released": self.Parameters.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }

    def on_execute(self):
        self.generate_ammo()
        self.generate_config()

    def generate_ammo(self):
        data = sdk2.ResourceData(
            TplApiLoadAmmo(self, 'TplApi load ammo', 'ammo.txt')
        )
        host = self.Parameters.host
        secret = yav.Secret("sec-01fc32ew91b2d49fvbmhmkdk7a")

        db_host = secret.data()['db.host']
        db_username = secret.data()['tpl.int.jdbc.username']
        db_password = secret.data()['tpl.int.jdbc.password']
        db_dbname = secret.data()['db.dbname']
        db = TplDB(
            host=db_host,
            username=db_username,
            password=db_password,
            dbname=db_dbname
        )
        request_logs_resource = TplApiLoadRequestLogs.find(
            attrs={"released": "stable"}
        ).first()
        raw_request_definitions = get_raw_request_definitions(request_logs_resource)
        request_definition_service = RequestDefinitionService(db)
        request_definition_service.fill_request_definitions(raw_request_definitions)
        ammo.generate_ammo(host, raw_request_definitions)
        data.ready()

    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            TplApiLoadConfig(self, 'TplApi load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule=self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()


class TplApiLoadAmmo(Resource):
    pass


class TplApiLoadConfig(Resource):
    pass


class TplApiLoadRequestLogs(Resource):
    pass
