import six
import io

import tpl_api_client


def bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)


class TplApiRequestGenerator:
    def __init__(self, api_client, request_definitions):
        self.tpl_api_client = api_client
        self.endpoint_email_pairs = request_definitions

    def make_bullet(self, request_definition):
        page_id = request_definition['page_id']
        rq = self.tpl_api_client.raw_request_get(request_definition['endpoint'], request_definition['user_email'])
        return bullet(rq, page_id)


def generate_ammo(host, request_definitions):
    api_client = tpl_api_client.TplApiClient(host)
    request_generator = TplApiRequestGenerator(api_client, request_definitions)

    with io.open('ammo.txt', 'w', encoding='utf-8') as f:
        batch_size = 100000
        result = []

        for i in range(0, len(request_definitions), batch_size):
            chunk = request_definitions[i:i + batch_size]
            for j in range(len(chunk)):
                request_definition = request_definitions[j]
                if 'user_email' in request_definition:
                    result.append(request_generator.make_bullet(request_definition))
            f.write(six.text_type('\n'.join(result), 'utf-8'))
            f.flush()
