def get_rq_text(method, endpoint, host, email):
    headers_str = ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers(host, email).items()])
    return '{} {} {}\r\n{}\r\n'.format(
        method,
        endpoint,
        'HTTP/1.1',
        headers_str
    )


def headers(host, email):
    return {
        'Host': host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Encoding': 'utf-8',
        'Stress-Test-User-Email': email
    }


class TplApiClient:
    def __init__(self, host):
        self.host = host
        self.url = 'https://' + host

    def raw_request_get(self, endpoint, email):
        return get_rq_text(
            method='GET',
            endpoint=endpoint,
            host=self.host,
            email=email
        )
