class TplDB:
    def __init__(self, host, username, password, dbname):
        import psycopg2
        self.host = host
        self.username = username
        self.password = password
        self.dbname = dbname
        self.conn = psycopg2.connect(
            host=host,
            user=username,
            password=password,
            dbname=dbname,
            port=6432
        )

    def get_task_user_mappings(self, task_ids):
        cur = self.conn.cursor()
        cur.execute(
            '''
            select t.id, email
            from task t
            join route_point rp on t.route_point_id = rp.id
            join user_shift us on rp.user_shift_id = us.id
            join users u on us.user_id = u.id
            where t.id = any(%s)
            ;
            ''',
            (task_ids,)
        )
        records = cur.fetchall()
        return {r[0]: {'user_email': r[1]} for r in records}

    def get_route_point_user_mappings(self, route_point_ids):
        cur = self.conn.cursor()
        cur.execute(
            '''
            select rp.id, email
            from route_point rp
            join user_shift us on rp.user_shift_id = us.id
            join users u on us.user_id = u.id
            where rp.id = any(%s)
            ;
            ''',
            (route_point_ids,)
        )
        records = cur.fetchall()
        return {r[0]: {'user_email': r[1]} for r in records}

    def get_user_shifts_user_mappings(self, user_shift_ids):
        cur = self.conn.cursor()
        cur.execute(
            '''
            select us.id, email
            from user_shift us
            join users u on us.user_id = u.id
            where us.id = any(%s)
            ;
            ''',
            (user_shift_ids,)
        )
        records = cur.fetchall()
        return {r[0]: {'user_email': r[1]} for r in records}
