import const
import ammo
import codecs
import os.path

from sandbox import sdk2
from sandbox.projects.market.tpl.resources import TplIntLoadAmmo
from sandbox.projects.market.tpl.resources import TplIntLoadConfig

default_profile = {
    ammo.create_order: 5,
    ammo.create_pickup_order: 5,
    ammo.put_movement: 1,
}

config_yaml_template = 'config/check.yaml.template'


def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string


class MarketTplIntLoadGenerateAmmo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)
        host = sdk2.parameters.String('Host', default=const.HOST)

    def on_execute(self):
        self.generate_ammo()
        self.generate_config()

    def generate_ammo(self):
        data = sdk2.ResourceData(
            TplIntLoadAmmo(self, 'TplInt load ammo', 'ammo.txt')
        )
        bullet_count = self.Parameters.bullet_count
        host = self.Parameters.host
        ammo.generate_ammo(bullet_count, default_profile, host)
        data.ready()

    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            TplIntLoadConfig(self, 'TplInt load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule=self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()
