import io
import math
import random

from uuid import uuid4

import sandbox.projects.market.tpl.common.tpl_ds_api as tpl_ds_api

token_pool = [
    'stress-test-token-1',
    'stress-test-token-2',
    'stress-test-token-3'
]


def generate_bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)


def order_yandex_id():
    return 'stress-test-' + str(uuid4())


def create_order(ds_api_client):
    return generate_bullet(ds_api_client.request_text(tpl_ds_api.tpl_create_common_order_body(
        random.choice(token_pool),
        order_yandex_id()
    )), 'createOrder')


def create_pickup_order(ds_api_client):
    return generate_bullet(ds_api_client.request_text(tpl_ds_api.tpl_create_pickup_order_body(
        random.choice(token_pool),
        order_yandex_id()
    )), 'createPickupOrder')


def put_movement(ds_api_client):
    return generate_bullet(ds_api_client.request_text(tpl_ds_api.tpl_put_movement_body(
        random.choice(token_pool),
        order_yandex_id()
    )), 'putMovement')


def generate_ammo(bullet_count, profile, host):
    ds_api_client = tpl_ds_api.DSApiClient(
        host,
        '/delivery/query-gateway'
    )

    with io.open('ammo.txt', 'w', encoding='utf-8') as f:
        batch_size = 100000
        profile_total = sum([value for (key, value) in profile.items()])
        single_bullet_count = batch_size / profile_total

        for _ in range(int(math.ceil(bullet_count / float(batch_size)))):
            result = []
            for (key, value) in profile.items():
                for _ in range(value * single_bullet_count):
                    result.append(key(ds_api_client))

            random.shuffle(result)
            f.write(unicode('\n'.join(result), 'utf-8'))
            f.flush()
