import const
import ammo
import codecs

from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sdk2 import (Resource)

from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task

from tpl_db import TplDB

default_profile = {
    ammo.TplTrackingRandomRequestGenerator.get_tracking: 5,
    ammo.TplTrackingRandomRequestGenerator.get_tracking_courier_location: 12,
}

config_yaml_template = 'config/check.yaml.template'


def get_resource(file_name):
    from library.python import resource
    return resource.find(file_name)


class MarketTplTrackingLoadGenerateAmmo(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        schedule = sdk2.parameters.String('Schedule', default=const.DEFAULT_SCHEDULE)
        bullet_count = sdk2.parameters.Integer('Bullet count', default=const.DEFAULT_BULLET_COUNT)
        host = sdk2.parameters.String('Host', default=const.HOST)
        ext_params = binary_task.binary_release_parameters(stable=True)

    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "task_type": "MARKET_TPL_TRACKING_LOAD_GENERATE_AMMO",
                "released": self.Parameters.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }

    def on_execute(self):
        self.generate_ammo()
        self.generate_config()

    def generate_ammo(self):
        data = sdk2.ResourceData(
            TplTrackingLoadAmmo(self, 'TplTracking load ammo', 'ammo.txt')
        )
        bullet_count = self.Parameters.bullet_count
        host = self.Parameters.host
        secret = yav.Secret("sec-01fc32ew91b2d49fvbmhmkdk7a")

        db_host = secret.data()['db.host']
        db_username = secret.data()['tpl.int.jdbc.username']
        db_password = secret.data()['tpl.int.jdbc.password']
        db_dbname = secret.data()['db.dbname']
        db = TplDB(
            host=db_host,
            username=db_username,
            password=db_password,
            dbname=db_dbname
        )
        tracking_ids = db.get_tracking_ids()
        ammo.generate_ammo(bullet_count, default_profile, host, tracking_ids)
        data.ready()

    def generate_config(self):
        config_file_name = 'check.yaml'
        config_resource = sdk2.ResourceData(
            TplTrackingLoadConfig(self, 'TplTracking load config', config_file_name)
        )
        config = get_resource(config_yaml_template).format(
            schedule=self.Parameters.schedule
        )
        with codecs.open(config_file_name, 'w', encoding='utf-8') as f:
            f.write(config)
        config_resource.ready()


class TplTrackingLoadAmmo(Resource):
    pass


class TplTrackingLoadConfig(Resource):
    pass
