import io
import math
import random

import tpl_tracking_client


def bullet(req, label):
    return '{} {}\n{}'.format(str(len(req.encode('utf-8'))), label, req)


class TplTrackingRandomRequestGenerator:
    def __init__(self, tracking_client, tracking_ids):
        self.tracking_client = tracking_client
        self.tracking_ids = tracking_ids

    def pick_tracking_id(self):
        return random.choice(self.tracking_ids)

    def get_tracking(self):
        tracking_id = self.pick_tracking_id()
        rq = self.tracking_client.get_tracking(tracking_id)
        return bullet(rq, 'tracking_id')

    def get_tracking_courier_location(self):
        tracking_id = self.pick_tracking_id()
        rq = self.tracking_client.get_tracking_courier_location(tracking_id)
        return bullet(rq, 'tracking_id_courier_location')


def generate_ammo(bullet_count, profile, host, tracking_ids):
    tracking_client = tpl_tracking_client.TplTrackingClient(host)
    tracking_request_generator = TplTrackingRandomRequestGenerator(tracking_client, tracking_ids)

    with io.open('ammo.txt', 'w', encoding='utf-8') as f:
        batch_size = 100000
        profile_total = sum([value for (key, value) in profile.items()])
        single_bullet_count = batch_size / profile_total

        for _ in range(int(math.ceil(bullet_count / float(batch_size)))):
            result = []
            for (key, value) in profile.items():
                for _ in range(value * single_bullet_count):
                    result.append(key(tracking_request_generator))

            random.shuffle(result)
            f.write(unicode('\n'.join(result), 'utf-8'))
            f.flush()
