class TplDB:
    def __init__(self, host, username, password, dbname):
        import psycopg2
        self.host = host
        self.username = username
        self.password = password
        self.dbname = dbname
        self.conn = psycopg2.connect(
            host=host,
            user=username,
            password=password,
            dbname=dbname,
            port=6432
        )

    def get_tracking_ids(self):
        cur = self.conn.cursor()
        cur.execute('''
            select t.id
            from tracking t
            join task_order_delivery tod on t.order_delivery_task_id = tod.id
            join orders o on tod.order_id = o.id
            order by o.id desc
            limit 10000
            ;
        ''')
        records = cur.fetchall()
        return [r[0] for r in records]

