def get_rq_text(method, endpoint, host):
    headers_str = ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers(host).items()])
    return '{} {} {}\r\n{}\r\n'.format(
        method,
        endpoint,
        'HTTP/1.1',
        headers_str
    )

def headers(host):
    return {
        'Host': host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Encoding': 'utf-8',
    }


class TplTrackingClient():
    def __init__(self, host):
        self.host = host
        self.url = 'https://' + host

    def get_tracking(self, tracking_id):
        return get_rq_text(
            method='GET',
            endpoint='/internal/tracking/{}'.format(tracking_id),
            host=self.host
        )

    def get_tracking_courier_location(self, tracking_id):
        return get_rq_text(
            method='GET',
            endpoint='/internal/tracking/{}/courier-location'.format(tracking_id),
            host=self.host
        )
