import requests
import os.path
import random
from datetime import date

# disable https checks
requests.packages.urllib3.disable_warnings()

ff_template_path = 'ff/'

create_xml_template = ff_template_path + 'createOrder.xml'
update_xml_template = ff_template_path + 'updateOrder.xml'
cancel_xml_template = ff_template_path + 'cancelOrder.xml'
return_xml_template = ff_template_path + 'createReturnRegister.xml'
get_status_xml_template = ff_template_path + 'getOrdersStatus.xml'
get_history_xml_template = ff_template_path + 'getOrderHistory.xml'

courier_pool = range(100)

def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string


def create_order_body(token, yandex_id):
    return get_resource(create_xml_template).format(
        token = token,
        yandex_id = yandex_id
    )

def update_order_body(token, yandex_id):
    delivery_date = str(date.today())
    courier_id = random.choice(courier_pool)
    return get_resource(update_xml_template).format(
        token = token,
        yandex_id = yandex_id,
        delivery_date = delivery_date,
        courier_id = courier_id
    )

def update_order_body_courier(token, yandex_id, courier_id):
    delivery_date = str(date.today())
    return get_resource(update_xml_template).format(
        token = token,
        yandex_id = yandex_id,
        delivery_date = delivery_date,
        courier_id = courier_id
    )

def cancel_order_body(token, yandex_id):
    return get_resource(cancel_xml_template).format(
        token = token,
        yandex_id = yandex_id
    )

def return_order_body(token, yandex_id):
    return get_resource(return_xml_template).format(
        token = token,
        yandex_id = yandex_id
    )

def get_order_status_body(token, yandex_ids):
    order_id_template = '<orderId>\n' \
        '  <yandexId>{}</yandexId>\n' \
        '</orderId>\n'
    order_ids = ''.join([order_id_template.format(yandex_id) for yandex_id in yandex_ids])
    return get_resource(get_status_xml_template).format(
        token = token,
        order_ids = order_ids
    )

def get_order_history_body(token, yandex_id):
    return get_resource(get_history_xml_template).format(
        token = token,
        yandex_id = yandex_id
    )


def headers(host, body):
    return {
        'Content-Type': 'text/xml',
        'Host': host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Encoding': 'utf-8',
        'Content-Length': str(len(body.encode('utf-8')))
    }


class FFApiClient():
    def __init__(self, host, endpoint, token):
        self.host = host
        self.endpoint = endpoint
        self.url = 'https://' + host + endpoint
        self.token = token

    def create_order(self, yandex_id):
        body = create_order_body(self.token, yandex_id)
        return requests.post(
            self.url, 
            data=body.encode('utf-8'), 
            headers=headers(self.host, body),
            verify=False
        ).text

    def update_order(self, yandex_id):
        body = update_order_body(self.token, yandex_id)
        return requests.post(
            self.url, 
            data=body.encode('utf-8'), 
            headers=headers(self.host, body),
            verify=False
        ).text

    def update_order_courier(self, yandex_id, courier_id):
        body = update_order_body_courier(self.token, yandex_id, courier_id)
        return requests.post(
            self.url, 
            data=body.encode('utf-8'), 
            headers=headers(self.host, body),
            verify=False
        ).text

    def request_text(self, body):
        return 'POST ' + self.endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in headers(self.host, body).items()]) + '\r\n' + body.encode('utf-8') + '\r\n'
    