import requests
import os.path
import json
from datetime import date

# disable https checks
requests.packages.urllib3.disable_warnings()

class PvzIntClient():
    def __init__(self, host):
        self.host = host
        self.url = 'https://' + host

    def get_pickup_points(self, partner_id):
        return requests.get(
            self.url + '/v1/pi/partners/{}/pickup-points?size=30000'.format(partner_id),
            verify = False
        ).json()

    def create_orders_in_status(self, pvzMarketId, ordersCount, status):
        return requests.post(
            self.url + '/manual/orders/create',
            verify = False,
            json = {
                "ordersCount": ordersCount,
                "pvzMarketId": pvzMarketId,
                "orderStatus": status,
                "recipient": {
                    "name": "load test"
                }
            }
        ).json()

