import requests
import os.path
import json
from datetime import date

# disable https checks
requests.packages.urllib3.disable_warnings()

class ScIntClient():
    def __init__(self, host):
        self.host = host
        self.url = 'https://' + host
        self.uid = 1123533710

    def accept_order(self, yandex_id):
        return requests.post(
            self.url + '/manual/orders/accept?externalOrderId={}&uid={}'.format(yandex_id, self.uid),
            verify=False
        ).text

    def sort_order(self, yandex_id):
        order = json.loads(self.get_order(yandex_id))
        cell_id = order['routeTo']['cell']['id']
        return requests.post(
            self.url + '/manual/orders/sort?externalOrderId={}&uid={}&cellId={}'.format(yandex_id, self.uid, cell_id),
            verify=False
        ).text

    def get_order(self, yandex_id):
        return requests.get(
            self.url + '/manual/orders?externalId={}&uid={}'.format(yandex_id, self.uid),
            verify=False
        ).text

    def get_route(self, courier_id):
        return requests.get(
            self.url + '/manual/routes/courier?scId=1&routeType=OUTGOING_COURIER&date={}&courierId={}'.format(str(date.today()), courier_id),
            verify=False
        ).text
