import os.path

import requests

# disable https checks
requests.packages.urllib3.disable_warnings()

ds_template_path = 'ds/'

create_pickup_order_xml_template = ds_template_path + 'createPickupOrder.xml'
create_common_order_xml_template = ds_template_path + 'createCommonOrder.xml'
put_movement_xml_template = ds_template_path + 'putMovement.xml'


def get_resource(file_name):
    path = os.path.join(os.path.dirname(__file__), file_name)
    with open(path, 'r') as f:
        file_string = f.read()
    return file_string


ds_template_path = 'ds/'
common_order = get_resource(ds_template_path + 'createPickupOrder.xml')
pickup_order = get_resource(ds_template_path + 'createCommonOrder.xml')
put_movement = get_resource(ds_template_path + 'putMovement.xml')


def tpl_create_common_order_body(token, yandex_id):
    return common_order.format(
        token=token,
        yandex_id=yandex_id
    )


def tpl_create_pickup_order_body(token, yandex_id):
    return pickup_order.format(
        token=token,
        yandex_id=yandex_id
    )


def tpl_put_movement_body(token, yandex_id):
    return put_movement.format(
        token=token,
        yandex_id=yandex_id
    )


def headers(host, body):
    return {
        'Content-Type': 'text/xml',
        'Host': host,
        'User-Agent': 'curl/7.54.0',
        'Accept': '*/*',
        'Content-Encoding': 'utf-8',
        'Content-Length': str(len(body.encode('utf-8')))
    }


class DSApiClient():
    def __init__(self, host, endpoint):
        self.host = host
        self.endpoint = endpoint

    def request_text(self, body):
        return 'POST ' + self.endpoint + ' HTTP/1.1\r\n' + ''.join(['{}: {}\r\n'.format(key, value) for (key, value) in
                                                                    headers(self.host,
                                                                            body).items()]) + '\r\n' + body + '\r\n'
