PY2_LIBRARY()

OWNER(g:market-tpl)

PY_SRCS(
	__init__.py
    MarketScIntLoadGenerateAmmo/__init__.py
    MarketScIntLoadGenerateAmmo/ammo.py
    MarketScIntLoadGenerateAmmo/const.py
    MarketScApiLoadGenerateAmmo/__init__.py
    MarketScApiLoadGenerateAmmo/ammo.py
    MarketScApiLoadGenerateAmmo/const.py
    MarketPvzIntLoadGenerateAmmo/__init__.py
    MarketPvzIntLoadGenerateAmmo/ammo.py
    MarketPvzIntLoadGenerateAmmo/const.py
    MarketPvzIntLoadGenerateAmmo/local_test.py
    MarketTplIntLoadGenerateAmmo/__init__.py
    MarketTplIntLoadGenerateAmmo/ammo.py
    MarketTplIntLoadGenerateAmmo/const.py
    MarketTplIntLoadGenerateAmmo/local_test.py
    MarketTplTrackingLoadGenerateAmmo/__init__.py
    MarketTplTrackingLoadGenerateAmmo/ammo.py
    MarketTplTrackingLoadGenerateAmmo/const.py
    MarketTplTrackingLoadGenerateAmmo/local_test.py
    MarketTplTrackingLoadGenerateAmmo/tpl_db.py
    resources/__init__.py
    common/__init__.py
    common/ff_api.py
    common/sc_int_client.py
    common/ds_api.py
    common/pvz_int_client.py
    common/tpl_ds_api.py
    MarketTplTrackingLoadGenerateAmmo/tpl_tracking_client.py
)

PEERDIR(
	library/python/resource
	sandbox/projects/market/tpl/MarketScIntLoadGenerateAmmo
    sandbox/projects/market/tpl/MarketScApiLoadGenerateAmmo
    sandbox/projects/market/tpl/MarketPvzIntLoadGenerateAmmo
    sandbox/projects/market/tpl/MarketTplIntLoadGenerateAmmo
    sandbox/projects/market/tpl/MarketTplTrackingLoadGenerateAmmo
    sandbox/projects/market/tpl/MarketTplApiLoadGenerateAmmo
    sandbox/projects/market/tpl/resources
    sandbox/projects/market/tpl/common
    contrib/python/psycopg2
)

SET(SC_INT_LOAD_DIR "sandbox/projects/market/tpl/MarketScIntLoadGenerateAmmo")
SET(SC_API_LOAD_DIR "sandbox/projects/market/tpl/MarketScApiLoadGenerateAmmo")

SET(PVZ_INT_LOAD_DIR "sandbox/projects/market/tpl/MarketPvzIntLoadGenerateAmmo")

SET(TPL_INT_LOAD_DIR "sandbox/projects/market/tpl/MarketTplIntLoadGenerateAmmo")
SET(TPL_TRACKING_LOAD_DIR "sandbox/projects/market/tpl/MarketTplTrackingLoadGenerateAmmo")

SET(COMMON_DIR "sandbox/projects/market/tpl/common")
RESOURCE(
    MarketScIntLoadGenerateAmmo/config/check.yaml.template ${SC_INT_LOAD_DIR}/config/check.yaml.template
    MarketScApiLoadGenerateAmmo/config/check.yaml.template ${SC_API_LOAD_DIR}/config/check.yaml.template
    common/ff/createOrder.xml ${COMMON_DIR}/ff/createOrder.xml
    common/ff/updateOrder.xml ${COMMON_DIR}/ff/updateOrder.xml
    common/ff/cancelOrder.xml ${COMMON_DIR}/ff/cancelOrder.xml
    common/ff/createReturnRegister.xml ${COMMON_DIR}/ff/createReturnRegister.xml
    common/ff/getOrderHistory.xml ${COMMON_DIR}/ff/getOrderHistory.xml
    common/ff/getOrdersStatus.xml ${COMMON_DIR}/ff/getOrdersStatus.xml

    MarketPvzIntLoadGenerateAmmo/config/check.yaml.template ${PVZ_INT_LOAD_DIR}/config/check.yaml.template
    common/ds/createOrder.xml ${COMMON_DIR}/ds/createOrder.xml
    common/ds/updateOrder.xml ${COMMON_DIR}/ds/updateOrder.xml
    common/ds/getOrderHistory.xml ${COMMON_DIR}/ds/getOrderHistory.xml
    common/ds/getOrdersStatus.xml ${COMMON_DIR}/ds/getOrdersStatus.xml

    MarketTplIntLoadGenerateAmmo/config/check.yaml.template ${TPL_INT_LOAD_DIR}/config/check.yaml.template
    common/ds/createCommonOrder.xml ${COMMON_DIR}/ds/createCommonOrder.xml
    common/ds/createPickupOrder.xml ${COMMON_DIR}/ds/createPickupOrder.xml
    common/ds/putMovement.xml ${COMMON_DIR}/ds/putMovement.xml

    MarketTplTrackingLoadGenerateAmmo/config/check.yaml.template ${TPL_TRACKING_LOAD_DIR}/config/check.yaml.template

)

END()

RECURSE(
	MarketScIntLoadGenerateAmmo
    MarketScApiLoadGenerateAmmo
    MarketPvzIntLoadGenerateAmmo
    MarketTplIntLoadGenerateAmmo
    MarketTplTrackingLoadGenerateAmmo
    MarketTplApiLoadGenerateAmmo
    resources
    common
)
