import logging
import json
import io

from optparse import OptionParser
from yql.api.v1.client import YqlClient


logging.basicConfig(
    level=logging.DEBUG,
    format='[%(levelname)s %(asctime)s]: %(message)s',
    datefmt='%m-%d-%Y %I:%M:%S'
)

parser = OptionParser()

parser.add_option("--token-file", help="File with YQL auth token")
parser.add_option("--query-file", help="File with YQL Query")
parser.add_option("--out", help="Path of result file")

options = parser.parse_args()[0]

SERVER = 'yql.yandex.net'
RESULT_FILE = options.out

with io.open(options.token_file) as fp:
    TOKEN = fp.read()

with io.open(options.query_file, encoding='utf-8') as fp:
    QUERY = fp.read()

yql_client = YqlClient(server=SERVER, token=TOKEN)


def exec_query(query):
    logging.info('Make query:\n%s', query)

    request = yql_client.query(query, syntax_version=1)
    request.encoding = 'utf-8'
    request.run()

    if not request.get_results().is_success:
        error_description = '\n'.join([str(err) for err in request.get_results().errors])
        logging.error(error_description)
        raise RuntimeError(error_description)

    try:
        request.get_results().table.fetch_full_data()
    except AttributeError:
        return None

    return request.get_results().table


def dump_table(table):
    logging.info('Dump results to file: %s', RESULT_FILE)

    result = []
    columns = table.columns
    rows = table.rows
    keys = map(lambda (key, _): key, columns)

    for row in rows:
        result.append(dict(zip(keys, row)))

    with io.open(RESULT_FILE, 'w', encoding='utf-8') as res_file:
        res_file.write(json.dumps(result, ensure_ascii=False, encoding='utf-8'))


table = exec_query(QUERY)
if table:
    dump_table(table)
