from sandbox.projects.sandbox.sandbox_lxc_image import (
    SandboxLxcImage,
    UbuntuRelease
)
from sandbox.projects.market.wms.WmsLxcContainer import WmsLxcContainer


CUSTOM_SCRIPT = [
    'apt-get update',
    'apt-get install -y curl',
    'curl https://packages.microsoft.com/keys/microsoft.asc | apt-key add -',
    'curl https://packages.microsoft.com/config/ubuntu/18.04/prod.list > /etc/apt/sources.list.d/mssql-release.list',
    'apt-get update',
    'ACCEPT_EULA=Y apt-get install -y msodbcsql17'
]


class CreateWmsLxcContainer(SandboxLxcImage):

    class Requirements(SandboxLxcImage.Requirements):
        privileged = True

    class Parameters(SandboxLxcImage.Parameters):
        resource_description = SandboxLxcImage.Parameters.resource_description(default="LXC container with ms sql odbc driver")

        install_common = SandboxLxcImage.Parameters.install_common(default=True)
        test_result_lxc = SandboxLxcImage.Parameters.test_result_lxc(default=False)

        custom_image = SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.BIONIC)
        resource_type = SandboxLxcImage.Parameters.resource_type(default=WmsLxcContainer.name)
        custom_attrs = SandboxLxcImage.Parameters.custom_attrs(default={"ttl": "inf"})
        custom_script = SandboxLxcImage.Parameters.custom_script(default="\n".join(CUSTOM_SCRIPT))
