import logging

import sandbox.common.types.task as Ctt
from sandbox import sdk2
from sandbox.projects.sandbox.resources import LXC_CONTAINER
from sandbox.common.types.resource import State
from sandbox.sdk2.service_resources import SandboxTasksBinary
from sandbox.projects.market.wms.WmsLxcContainer import WmsLxcContainer as WMS_LXC_CONTAINER


class WmsAutoInsertRelocBoxes(sdk2.Task):

    def on_create(self):
        self.Requirements.container_resource = LXC_CONTAINER.find(
            resource_type=WMS_LXC_CONTAINER,
            state=State.READY,
            attrs={
                "released": Ctt.ReleaseStatus.STABLE
            }
        ).first()

        self.Requirements.tasks_resource = SandboxTasksBinary.find(
            state=State.READY,
            attrs={
                "task_type": "WMS_AUTO_INSERT_RELOC_BOXES",
                "released": Ctt.ReleaseStatus.STABLE
            }
        ).first()

    def on_execute(self):
        logging.debug('start script')
        secrets = self.init_secrets()

        rs_and_os = self.get_receipts_and_orders(secrets.ff_wf)

        logging.info("Receipts and Orders: " + "'" + " | ".join(
            'receipt_key=' + str(row[0]) + '; order_key=' + str(row[1]) + '; warehouse_to=' + str(row[2]) + '; warehouse_from=' + str(row[3]) for row in rs_and_os))

        for r_and_o in rs_and_os:
            boxes = self.get_boxes(secrets, r_and_o[3], r_and_o[1])
            logging.info("Receipt=" + r_and_o[1] + "; Warehouse=" + str(r_and_o[3]) + "; Boxes=" + ", ".join(boxes))
            if len(boxes) > 0:
                self.update_receipt(secrets, r_and_o[2], r_and_o[0], boxes)

        logging.debug('finish script')

    def init_secrets(self):
        return sdk2.yav.Yav(
            ff_wf=sdk2.yav.Secret('sec-01dz4kwx48yzq49m9qwsae51wr'),
            sof_arh=sdk2.yav.Secret('sec-01e6ezqstcm3tj8tepdf9qk03p'),
            tom_arh=sdk2.yav.Secret('sec-01e6f25f1sfwpp93stajqnzkgm'),
            ekb=sdk2.yav.Secret('sec-01f0gnteccw08vt226vj38yrky'),
            rst=sdk2.yav.Secret('sec-01dmahy8tmzdphfacfqfs1te4e'),
            spb=sdk2.yav.Secret('sec-01f4c92ejq44x7m0j7qkpg1d3m'),
            sam=sdk2.yav.Secret('sec-01f7nfe0eze3yf1cxq1hfmcgy2'),
            retsof=sdk2.yav.Secret('sec-01faj9998fanj8ygqmgse2qmgz')
        )

    def get_receipts_and_orders(self, secret):
        import psycopg2

        secretsDict = dict()
        for str in secret['ff-wf-secrets.properties'].split('\n'):
            str = str.split('=')
            secretsDict.update({str[0]: str[1]})

        user = secretsDict['ff.workflow.db.username']
        psswd = secretsDict['ff.workflow.db.password']

        sql = """
                SELECT r.service_request_id AS receipt_key, r1.service_request_id as order_key,
                    r.service_id as warehouse_to, r1.service_id as warehouse_from
                FROM public.shop_request AS r
                    INNER JOIN public.shop_request AS r1 ON r1.external_request_id = r.external_request_id
                       AND r1.supplier_id = r.supplier_id AND r1.type = 17 AND r1.service_id IN (172, 171) AND r1.status NOT IN (4, 5, 8)
                WHERE r.status = 3 AND r.type = 16 AND r.service_id IN (302, 301, 300, 147, 500)"""

        from psycopg2.extras import DictCursor
        with psycopg2.connect(dbname='market_ff_workflow', user=user, password=psswd,
                              host='market-ff-workflow01h.db.yandex.net', port=6432) as conn:
            with conn.cursor(cursor_factory=DictCursor) as cursor:
                cursor.execute(sql)
                return cursor.fetchall()

    def get_mssql_conn(self, secrets, warehouse):
        import pyodbc

        if warehouse == 300:
            server = 'sql-wms-ekb.mast.yandex.ru,1433'
            secret = secrets.ekb
        elif warehouse == 172:
            secret = secrets.sof_arh
            server = 'sql-arch.mast.yandex.ru,1433'
        elif warehouse == 171:
            secret = secrets.tom_arh
            server = 'sql-arch-tom.mast.yandex.ru,3433'
        elif warehouse == 147:
            secret = secrets.rst
            server = 'sql-rst2.mast.yandex.ru,1433'
        elif warehouse == 301:
            secret = secrets.spb
            server = 'sql-wms-spb.mast.yandex.ru,2433'
        elif warehouse == 302:
            secret = secrets.sam
            server = 'sql-wms-smr.mast.yandex-team.ru,4433'
        elif warehouse == 500:
            secret = secrets.retsof
            server = 'sql-wms-ret01.mast.yandex-team.ru,8433'
        else:
            raise Exception("Unknown warehouse {0}".format(warehouse))

        driver = '{ODBC Driver 17 for SQL Server}'
        user = secret['DbWh1User']
        psswd = secret['DbWh1Pass']
        db = 'SCPRD'

        return pyodbc.connect(driver=driver, server=server, uid=user,
                              pwd=psswd, database=db)

    def get_boxes(self, secrets, warehouse, order_key):
        sql = """
                SELECT DISTINCT PD.DROPID
                FROM SCPRD.wmwhse1.PICKDETAIL AS PD
                WHERE PD.ORDERKEY = ? AND PD.DROPID LIKE 'DRP%'"""
        ret = []

        with self.get_mssql_conn(secrets, warehouse) as conn:
            with conn.cursor() as cursor:
                cursor.execute(sql, order_key)
                for row in cursor:
                    ret.append(row[0])

        return ret

    def update_receipt(self, secrets, warehouse, receipt_key, boxes):
        with_sql = """WITH NUM(NUM) AS(SELECT MAX(RD.RECEIPTLINENUMBER) FROM wmwhse1.RECEIPTDETAIL AS RD WHERE RD.RECEIPTKEY = ?) """

        insert_sql = """INSERT INTO wmwhse1.RECEIPTDETAIL (ReceiptKey, ReceiptLineNumber, ToId, StorerKey, Sku, QtyReceived, ToLoc, lottable08, lottable09,
                         Uom, ReasonCode, AddWho, EditWho, Supplierkey, POLineNumber, SUSR1, ORIGINALLINENUMBER ,CHECKFORBACKFLUSHING, HOSTPROCESSREQUIRED, status, WHSEID) """

        select_sql = """
                    SELECT ? AS ReceiptKey, RIGHT(CAST(100000 + (SELECT N.NUM FROM NUM AS N) + (ROW_NUMBER() OVER (ORDER BY B.BOXID)) AS VARCHAR(6)), 5) AS ReceiptLineNumber,
                         B.BOXID AS ToId, 'PL' As StorerKey, 'PL' AS Sku, 1 AS QtyReceived, 'LN19' AS ToLoc, '0' AS lottable08, 'ALL' AS lottable09, 'EA' AS Uom,  ' ' AS ReasonCode,
                         'auto-task' AS AddWho, 'auto-task' AS EditWho, '' AS Supplierkey, '' AS POLineNumber, '0' AS SUSR1, '-1' AS ORIGINALLINENUMBER, ' ' AS CHECKFORBACKFLUSHING,
                         ' ' AS HOSTPROCESSREQUIRED, '6' AS status, 'receiving' AS WHSEID
                    FROM (SELECT V.BOXID FROM (VALUES ('""" + """'),('""".join(boxes) + """')) AS V (BOXID)
                          WHERE EXISTS (SELECT * FROM wmwhse1.RECEIPT AS R WHERE R.RECEIPTKEY = ? AND R.[STATUS] = 0)
                              AND EXISTS (SELECT * FROM wmwhse1.RECEIPTDETAIL AS RD WHERE RD.RECEIPTKEY = ?)
                              AND NOT EXISTS (SELECT * FROM wmwhse1.RECEIPTDETAIL AS RD WHERE RD.RECEIPTKEY = ? AND RD.SKU = 'PL')
                    ) AS B"""

        with self.get_mssql_conn(secrets, warehouse) as conn:
            with conn.cursor() as cursor:
                cursor.execute(with_sql + insert_sql + select_sql, receipt_key, receipt_key, receipt_key, receipt_key, receipt_key)
            conn.commit()
