# coding=utf-8
import logging

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.common.types import resource as ctr


class WmsBinaryTemplate(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "task_type": "WMS_BINARY_TEMPLATE",  # change task type
                "released": self.Parameters.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }

    def on_execute(self):
        super(WmsBinaryTemplate, self).on_execute()
        logging.info("do work")

    # your code starts here
