# coding=utf-8

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.common import errors
from sandbox.common.types import resource as ctr
from sandbox.projects.common import binary_task


class WmsSearchReleaseResource(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        resource_type = sdk2.parameters.String("Resource type", required=True)
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.Output():
            resource_id = sdk2.parameters.String("Resource last release id")

    @property
    def binary_executor_query(self):
        return {
            "attrs": {
                "task_type": "WMS_SEARCH_RELEASE_RESOURCE",  # change task type
                "released": self.Parameters.binary_executor_release_type
            },
            "state": [ctr.State.READY]
        }

    def on_execute(self):
        super(WmsSearchReleaseResource, self).on_execute()
        latest_release = sdk2.Resource.find(type=self.Parameters.resource_type, attrs={"released": "stable"}).first()
        if latest_release:
            self.Parameters.resource_id = latest_release.id
        else:
            raise errors.TaskFailure("Cannot find release for type {type}"
                                     .format(type=self.Parameters.resource_type))
