import logging
from sandbox import sdk2
from sandbox.projects.sandbox_ci.utils.request import send_request

logger = logging.getLogger(__name__)

DATA_CREATOR_BUILD_TOPOLOGY = "/datacreator/training-class/generate"


class WmsTrainingClass(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        host = sdk2.parameters.String("host", required=True)

    def on_execute(self):
        url = self.Parameters.host[:-4] + DATA_CREATOR_BUILD_TOPOLOGY
        logging.debug("URL: {url}".format(url=url))
        status = send_request("post", url, headers=self.headers, max_retries=1)
        if status.status_code != 200:
            logging.debug("Response code:{code},  {text}".format(code=status.status_code, text=status.text))

    @property
    def headers(self):
        secret = sdk2.yav.Secret("sec-01fkjd4e7j3xsjxgfb9cqcbz7g")
        token = secret.data()["LgwApiToken"]
        return {
            "Content-Type": "application/json",
            "X-Token": token
        }
