# coding=UTF-8

import os
import shutil


def __collect_build_reports(work_dir):
    """
    Собирает все директории с отчетами сборки gradle
    """
    report_dirs = []
    for root, _, files in os.walk(work_dir):
        if files.count('build.gradle') > 0:
            report_dirs.append(root)
    return report_dirs


def copy_reports(work_dir, target_dir):
    """
    Копирует отчеты сборки

    work_dir
        папка с проектом
    target_dir
        папка, где будут собраны отчеты сборки
    """
    for module_root in __collect_build_reports(work_dir):
        report_dir = os.path.join(module_root, 'build', 'reports')
        if os.path.exists(report_dir):
            rel_path = os.path.relpath(report_dir, work_dir)
            shutil.copytree(report_dir, os.path.join(target_dir, rel_path))
