import re
from enum import Enum

TSUM_API = "https://tsum.yandex-team.ru/api/multitestings/project/{project}/environments/{name}"
TSUM_MT_INFO = TSUM_API
TSUM_STOP_MT = TSUM_API + "/cleanupAndArchiveForce"
TSUM_MT_API_URL = TSUM_API + "/createOrRestart"
TSUM_EXISTS_MT_API_URL = TSUM_API + "/exists"

TSUM_MT_PAGE_URL = "https://tsum.yandex-team.ru/pipe/projects/{project}/multitestings/environments/{name}"

MT_URL = "https://{project}--{name}.demofslb.market.yandex-team.ru"
MT_UI_URL = "https://{project}--{name}.demofslb.market.yandex-team.ru/ui/"


class DeployStatus(Enum):
    READY = 'READY'
    DEPLOYING = 'DEPLOYING'
    IDLE = 'IDLE'
    FAILED = 'DEPLOY_FAILED'


def tsum_mt_name(ticket_id, branch):
    if not branch:
        return ticket_id
    mt_name = re.sub(r'[^a-zA-Z0-9 \n\.]', '-', branch.lower())[0:51]
    return _remove_last_dashes(mt_name)


def balancer_url(tsum_project, mt_name):
    return MT_URL.format(project=tsum_project, name=mt_name)


def balancer_ui_url(tsum_project, mt_name):
    return MT_UI_URL.format(project=tsum_project, name=mt_name)


def tsum_api_url(tsum_project, mt_name):
    return TSUM_MT_API_URL.format(project=tsum_project, name=mt_name)


def tsum_page_url(tsum_project, mt_name):
    return TSUM_MT_PAGE_URL.format(project=tsum_project, name=mt_name)


def tsum_exists_mt_page_url(tsum_project, mt_name):
    return TSUM_EXISTS_MT_API_URL.format(project=tsum_project, name=mt_name)


def tsum_archive_url(tsum_project, mt_name):
    return TSUM_STOP_MT.format(project=tsum_project, name=mt_name)


def tsum_mt_status(tsum_project, mt_name):
    return TSUM_MT_INFO.format(project=tsum_project, name=mt_name)


def _remove_last_dashes(mt_name):
    while mt_name.endswith("-"):
        mt_name = mt_name[:len(mt_name) - 1]
    return mt_name
